/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.toolitem;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.status.AttributeInit;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.SpellComponent;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.register.ToolMaterialRegister;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.magic.cooldown.CooldownData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.network.TraitTickPayload;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.CuriosHelper;
import net.stln.magitech.util.MathUtil;
import net.stln.magitech.util.TextUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SpellCasterItem
extends PartToolItem {
    ResourceLocation atkId = Magitech.id("part_tool_attack_damage_modifier");
    ResourceLocation elmatkId = Magitech.id("part_tool_elemental_attack_damage_modifier");
    ResourceLocation spdId = Magitech.id("part_tool_attack_speed_modifier");
    ResourceLocation minId = Magitech.id("part_tool_mining_speed_modifier");
    ResourceLocation defId = Magitech.id("part_tool_defense_modifier");
    ResourceLocation rngId = Magitech.id("part_tool_attack_range_modifier");

    public SpellCasterItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            player = (Player)entity;
            if (player.getItemInHand(InteractionHand.MAIN_HAND) == stack || player.getItemInHand(InteractionHand.OFF_HAND) == stack) {
                SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack)).forEach((trait, integer) -> trait.tick(player, world, stack, (int)integer, SpellCasterItem.getBaseStats(stack), true));
                if (world.isClientSide) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new TraitTickPayload(player.getItemInHand(InteractionHand.MAIN_HAND) == stack, false, slot, entity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack)).forEach((trait, integer) -> trait.inventoryTick(player, world, stack, (int)integer, SpellCasterItem.getBaseStats(stack), true));
            if (world.isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TraitTickPayload(player.getItemInHand(InteractionHand.MAIN_HAND) == stack, true, slot, entity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            this.reloadComponent(player, world, stack);
        }
    }

    @Override
    public ToolStats getSumStats(Player player, Level level, ItemStack stack) {
        return this.getModifiedStats(player, level, stack);
    }

    @Override
    public ToolStats getModifiedStats(Player player, Level level, ItemStack stack) {
        Map<Trait, Integer> traits = SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack));
        ArrayList<ToolStats> statsList = new ArrayList<ToolStats>();
        statsList.add(SpellCasterItem.getBaseStats(stack));
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifySpellCasterStats1(stack, (int)value, SpellCasterItem.getBaseStats(stack)));
                statsList.add(trait.modifySpellCasterStatsConditional1(player, level, stack, (int)value, SpellCasterItem.getBaseStats(stack)));
            }
        });
        ToolStats stats1 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifySpellCasterStats2(stack, (int)value, stats1));
                statsList.add(trait.modifySpellCasterStatsConditional2(player, level, stack, (int)value, stats1));
            }
        });
        ToolStats stats2 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifySpellCasterStats3(stack, (int)value, stats2));
                statsList.add(trait.modifySpellCasterStatsConditional3(player, level, stack, (int)value, stats2));
            }
        });
        return ToolStats.add(statsList);
    }

    @Override
    public ToolStats getSumStatsWithoutConditional(ItemStack stack) {
        return this.getModifiedStatsWithoutConditional(stack);
    }

    @Override
    public ToolStats getModifiedStatsWithoutConditional(ItemStack stack) {
        Map<Trait, Integer> traits = SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack));
        ArrayList<ToolStats> statsList = new ArrayList<ToolStats>();
        statsList.add(SpellCasterItem.getBaseStats(stack));
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifySpellCasterStats1(stack, (int)value, SpellCasterItem.getBaseStats(stack)));
            }
        });
        ToolStats stats1 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifySpellCasterStats2(stack, (int)value, stats1));
            }
        });
        ToolStats stats2 = ToolStats.add(statsList);
        traits.forEach((trait, value) -> {
            if (trait != null) {
                statsList.add(trait.modifySpellCasterStats3(stack, (int)value, stats2));
            }
        });
        return ToolStats.add(statsList);
    }

    @Override
    public void onCraftedPostProcess(ItemStack stack, Level level) {
        super.onCraftedPostProcess(stack, level);
    }

    @Override
    public void reloadComponent(Player player, Level level, ItemStack stack) {
        EquipmentSlotGroup hand;
        ArrayList<ItemAttributeModifiers.Entry> entries = new ArrayList<ItemAttributeModifiers.Entry>();
        ToolStats finalStats = this.getSumStats(player, level, stack);
        Map<String, Float> map = finalStats.getStats();
        stack.set(ComponentInit.BROKEN_COMPONENT, (Object)(stack.getDamageValue() + 1 >= stack.getMaxDamage() ? 1 : 0));
        Map<String, Float> mod = ToolMaterialRegister.getModStats(this.getToolType()).getStats();
        EquipmentSlotGroup equipmentSlotGroup = hand = player.getItemInHand(InteractionHand.OFF_HAND).equals(stack) && !(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof SpellCasterItem) ? EquipmentSlotGroup.OFFHAND : EquipmentSlotGroup.MAINHAND;
        if (!ComponentHelper.isBroken((DataComponentHolder)stack)) {
            entries.add(new ItemAttributeModifiers.Entry(AttributeInit.SPELL_POWER, new AttributeModifier(this.atkId, (double)(map.get(ToolStats.ATK_STAT).floatValue() - mod.get(ToolStats.ATK_STAT).floatValue()), AttributeModifier.Operation.ADD_VALUE), hand));
            if (finalStats.getElement() != Element.NONE) {
                DeferredHolder<Attribute, Attribute> elementAttribute = switch (finalStats.getElement()) {
                    default -> throw new MatchException(null, null);
                    case Element.NONE -> null;
                    case Element.EMBER -> AttributeInit.EMBER_SPELL_POWER;
                    case Element.GLACE -> AttributeInit.GLACE_SPELL_POWER;
                    case Element.SURGE -> AttributeInit.SURGE_SPELL_POWER;
                    case Element.PHANTOM -> AttributeInit.PHANTOM_SPELL_POWER;
                    case Element.TREMOR -> AttributeInit.TREMOR_SPELL_POWER;
                    case Element.MAGIC -> AttributeInit.MAGIC_SPELL_POWER;
                    case Element.FLOW -> AttributeInit.FLOW_SPELL_POWER;
                    case Element.HOLLOW -> AttributeInit.HOLLOW_SPELL_POWER;
                };
                entries.add(new ItemAttributeModifiers.Entry(elementAttribute, new AttributeModifier(this.elmatkId, (double)map.get(ToolStats.ELM_ATK_STAT).floatValue(), AttributeModifier.Operation.ADD_VALUE), hand));
            }
            entries.add(new ItemAttributeModifiers.Entry(AttributeInit.CASTING_SPEED, new AttributeModifier(this.spdId, (double)(map.get(ToolStats.SPD_STAT).floatValue() - mod.get(ToolStats.SPD_STAT).floatValue()), AttributeModifier.Operation.ADD_VALUE), hand));
            entries.add(new ItemAttributeModifiers.Entry(AttributeInit.COOLDOWN_SPEED, new AttributeModifier(this.minId, (double)(map.get(ToolStats.MIN_STAT).floatValue() - mod.get(ToolStats.MIN_STAT).floatValue()), AttributeModifier.Operation.ADD_VALUE), hand));
            entries.add(new ItemAttributeModifiers.Entry(Attributes.ARMOR, new AttributeModifier(this.defId, (double)map.get(ToolStats.DEF_STAT).floatValue(), AttributeModifier.Operation.ADD_VALUE), hand));
            entries.add(new ItemAttributeModifiers.Entry(AttributeInit.PROJECTILE_SPEED, new AttributeModifier(this.rngId, (double)(map.get(ToolStats.RNG_STAT).floatValue() - mod.get(ToolStats.RNG_STAT).floatValue()), AttributeModifier.Operation.ADD_VALUE), hand));
            entries.add(new ItemAttributeModifiers.Entry(AttributeInit.MANA_EFFICIENCY, new AttributeModifier(this.rngId, (double)(map.get(ToolStats.SWP_STAT).floatValue() - mod.get(ToolStats.SWP_STAT).floatValue()), AttributeModifier.Operation.ADD_MULTIPLIED_BASE), hand));
            this.modifyTraitAttribute(player, level, stack, finalStats, entries);
        }
        ItemAttributeModifiers component = new ItemAttributeModifiers(entries, false);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)component);
        this.setTier(stack, finalStats);
        if ((float)stack.getMaxDamage() != map.get(ToolStats.DUR_STAT).floatValue()) {
            int newMaxDamage = Math.round(map.get(ToolStats.DUR_STAT).floatValue());
            int oldMaxDamage = stack.getMaxDamage();
            int oldDamage = stack.getDamageValue();
            if (newMaxDamage <= 0) {
                newMaxDamage = 1;
            }
            stack.set(DataComponents.MAX_DAMAGE, (Object)newMaxDamage);
            stack.setDamageValue((int)((float)oldDamage * (float)newMaxDamage / (float)oldMaxDamage));
        }
    }

    @Override
    protected void modifyTraitAttribute(Player player, Level level, ItemStack stack, ToolStats finalStats, List<ItemAttributeModifiers.Entry> entries) {
        SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack)).forEach((trait, value) -> trait.modifySpellCasterAttribute(player, level, stack, (int)value, finalStats, entries));
    }

    @Override
    public void postHurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        ToolStats stats = this.getSumStatsWithoutConditional(stack);
        return this.isCorrectTool(stack, state, (SpellCasterItem)stack.getItem(), stats);
    }

    @Override
    public void addStatsHoverText(@NotNull ItemStack stack, List<Component> tooltipComponents) {
        ToolStats finalStats = this.getSumStatsWithoutConditional(stack);
        this.setTier(stack, finalStats);
        Map<String, Float> mod = ToolMaterialRegister.getModStats(this.getToolType()).getStats();
        SpellCasterItem.addDefaultComponents(stack, tooltipComponents);
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.spell_power").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)TextUtil.toSignedIntPercent(finalStats.getStats().get(ToolStats.ATK_STAT).floatValue() - mod.get(ToolStats.ATK_STAT).floatValue())).withColor(0xFF4040)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.elemental_spell_power").append(": ").withColor(0xA0A0A0).append((Component)Component.translatable((String)("element.magitech." + finalStats.getElement().get())).append(" ").append((Component)Component.literal((String)TextUtil.toSignedIntPercent(finalStats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue()))).withColor(finalStats.getElement().getColor())));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.casting_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)TextUtil.toSignedIntPercent(finalStats.getStats().get(ToolStats.SPD_STAT).floatValue() - mod.get(ToolStats.SPD_STAT).floatValue())).withColor(4259776)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.cooldown_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)TextUtil.toSignedIntPercent(finalStats.getStats().get(ToolStats.MIN_STAT).floatValue() - mod.get(ToolStats.MIN_STAT).floatValue())).withColor(4227264)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.defense").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)String.valueOf(MathUtil.round(finalStats.getStats().get(ToolStats.DEF_STAT).floatValue(), 2))).withColor(0xA0C0C0)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.projectile_speed").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)TextUtil.toSignedIntPercent(finalStats.getStats().get(ToolStats.RNG_STAT).floatValue() - mod.get(ToolStats.RNG_STAT).floatValue())).withColor(8438015)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.mana_efficiency").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)TextUtil.toSignedIntPercent(finalStats.getStats().get(ToolStats.SWP_STAT).floatValue() - mod.get(ToolStats.SWP_STAT).floatValue())).withColor(0xFFFF80)));
        tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.durability").append(": ").withColor(0xA0A0A0).append((Component)Component.literal((String)(Math.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue()) - stack.getDamageValue() - 1 + " / " + Math.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue() - 1.0f))).withColor(0xFFFFFF)));
        tooltipComponents.add((Component)Component.empty());
        Map<Trait, Integer> traitIntegerMap = SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack));
        traitIntegerMap.forEach((trait, integer) -> {
            if (trait != null) {
                MutableComponent component = trait.getComponent().append(" ");
                if (integer < 6 && trait.getMaxLevel() != 1) {
                    for (int i = 0; i < (trait.getMaxLevel() == -1 ? integer : Math.min(integer, trait.getMaxLevel())); ++i) {
                        component.append("|");
                    }
                } else if (trait.getMaxLevel() != 1) {
                    component.append(integer.toString());
                }
                tooltipComponents.add((Component)component);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ItemStack threadbound = CuriosHelper.getThreadBoundStack((LivingEntity)player).orElse(ItemStack.EMPTY);
        if (!threadbound.isEmpty()) {
            SpellComponent spells = ComponentHelper.getSpells((DataComponentHolder)threadbound);
            if (spells.selected() < spells.spells().size()) {
                Spell spell = spells.getSelectedSpell();
                if (CooldownData.getPrevCooldown(player, spell) == null && spell.isActiveUse(level, player, usedHand, true)) {
                    boolean flag = spell.needsUseCost(level, player, stack) ? (ManaUtil.checkMana(player, spell.getRequiredMana(level, player, stack)) ? ManaUtil.useManaServerOnly(player, spell.getCost(level, player, stack)) || player.isCreative() : player.isCreative()) : true;
                    if (!flag) {
                        player.releaseUsingItem();
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    spell.use(level, player, usedHand, true);
                    SpellCasterItem.getTraitLevel(SpellCasterItem.getTraits(stack)).forEach((trait, integer) -> trait.onCastSpell(player, level, stack, (int)integer, this.getModifiedStats(player, level, stack)));
                } else {
                    player.releaseUsingItem();
                }
            } else {
                threadbound.set(ComponentInit.SPELL_COMPONENT, (Object)spells.setSelected(0));
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingUseDuration) {
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return;
        }
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            ItemStack threadbound = CuriosHelper.getThreadBoundStack((LivingEntity)user).orElse(ItemStack.EMPTY);
            if (!threadbound.isEmpty()) {
                SpellComponent spellComponent = ComponentHelper.getSpells((DataComponentHolder)threadbound);
                Spell spell = spellComponent.getSelectedSpell();
                if (CooldownData.getCurrentCooldown(user, spell) == null && spell.isActiveUsingTick(level, livingEntity, stack, this.getUseDuration(stack, livingEntity) - remainingUseDuration)) {
                    boolean flag = spell.needsTickCost(level, user, stack) ? ManaUtil.useManaServerOnly(user, spell.getTickCost(level, user, stack)) || user.isCreative() : true;
                    if (flag) {
                        spell.usingTick(level, livingEntity, stack, this.getUseDuration(stack, livingEntity) - remainingUseDuration);
                    } else {
                        user.releaseUsingItem();
                    }
                } else {
                    livingEntity.releaseUsingItem();
                }
            } else {
                livingEntity.releaseUsingItem();
            }
        }
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        if (ComponentHelper.isBroken((DataComponentHolder)stack)) {
            return;
        }
        super.releaseUsing(stack, level, livingEntity, timeCharged);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (level.isClientSide) {
                CuriosHelper.getThreadBoundStack((LivingEntity)user).ifPresent(threadbound -> {
                    SpellComponent spells = ComponentHelper.getSpells((DataComponentHolder)threadbound);
                    Spell spell = spells.getSelectedSpell();
                    spell.finishUsing(stack, level, livingEntity, this.getUseDuration(stack, livingEntity) - timeCharged, true);
                });
            }
        }
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public InteractionResult onLeftClick(Player user, InteractionHand hand, Level world) {
        return InteractionResult.PASS;
    }
}

