/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.BlockUtil;
import org.joml.Vector3f;

public class BirefringenceTrait
extends Trait {
    @Override
    public Set<BlockPos> addAdditionalBlockBreakFirst(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, Direction direction) {
        return BlockUtil.getConnectedBlocks(level, pos, blockState.getBlock(), traitLevel);
    }

    @Override
    public void onDamageEntity(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, Entity target) {
        LivingEntity livingEntity;
        super.onDamageEntity(player, level, stack, traitLevel, stats, target);
        if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).getHealth() < livingEntity.getMaxHealth() / 2.0f) {
            livingEntity.invulnerableTime = 0;
            DamageSource source = player.damageSources().playerAttack(player);
            livingEntity.hurt(source, (float)traitLevel);
        }
    }

    @Override
    public boolean emitEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        return !isInitial;
    }

    @Override
    public void addEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.addEffect(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new PowerupParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.9f, 1.0f, 1.0f), 1.0f, 1, 0.0f), (double)((float)pos.getX() + player.getRandom().nextFloat()), (double)((float)pos.getY() + player.getRandom().nextFloat()), (double)((float)pos.getZ() + player.getRandom().nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getColor() {
        return 0xF0FFFF;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.birefringence");
    }
}

