/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;

public class DuranceTrait
extends Trait {
    @Override
    public ToolStats modifyStats1(ItemStack stack, int traitLevel, ToolStats stats) {
        super.modifyStats1(stack, traitLevel, stats);
        ToolStats defaultStats = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(defaultStats.getStats());
        float mul = (float)traitLevel * 0.2f;
        modified.put(ToolStats.DUR_STAT, Float.valueOf(stats.getStats().get(ToolStats.DUR_STAT).floatValue() * mul));
        return new ToolStats(modified, defaultStats.getElement(), defaultStats.getMiningLevel(), defaultStats.getTier());
    }

    @Override
    public ToolStats modifySpellCasterStats1(ItemStack stack, int traitLevel, ToolStats stats) {
        super.modifySpellCasterStats1(stack, traitLevel, stats);
        ToolStats defaultStats = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(defaultStats.getStats());
        float mul = (float)traitLevel * 0.2f;
        modified.put(ToolStats.DUR_STAT, Float.valueOf(stats.getStats().get(ToolStats.DUR_STAT).floatValue() * mul));
        return new ToolStats(modified, defaultStats.getElement(), defaultStats.getMiningLevel(), defaultStats.getTier());
    }

    @Override
    public void onRepair(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, int repairAmount) {
        stack.setDamageValue((int)Math.max(0.0f, (float)stack.getDamageValue() - (float)(repairAmount * traitLevel) * 0.3f));
    }

    @Override
    public void testRepair(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, int repairAmount) {
        stack.setDamageValue((int)Math.max(0.0f, (float)stack.getDamageValue() - (float)(repairAmount * traitLevel) * 0.3f));
    }

    @Override
    public int getColor() {
        return 0xC0C0C0;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.durance");
    }
}

