/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.sound.SoundInit;
import org.joml.Vector3f;

public class GeoMendingTrait
extends Trait {
    @Override
    public ToolStats modifySpellCasterStats1(ItemStack stack, int traitLevel, ToolStats stats) {
        ToolStats aDefault = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
        float mul = (float)traitLevel * 0.8f;
        Float def = stats.getStats().get(ToolStats.DEF_STAT);
        modified.put(ToolStats.DEF_STAT, Float.valueOf(def.floatValue() * mul));
        return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
    }

    @Override
    public Boolean isCorrectTool(ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState) {
        if (blockState.getTags().anyMatch(Predicate.isEqual(BlockTags.BASE_STONE_OVERWORLD))) {
            return true;
        }
        return super.isCorrectTool(stack, traitLevel, stats, blockState);
    }

    @Override
    public void onBreakBlock(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.onBreakBlock(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        if (blockState.getTags().anyMatch(Predicate.isEqual(BlockTags.BASE_STONE_OVERWORLD)) && damageAmount > 0 && stack.getDamageValue() < stack.getMaxDamage() && player.getRandom().nextFloat() < (float)traitLevel * 0.22f) {
            stack.setDamageValue(stack.getDamageValue() - 1);
            level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundInit.GEOMENDING_BREAK.get(), SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
        }
    }

    @Override
    public boolean emitEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        return blockState.getTags().anyMatch(Predicate.isEqual(BlockTags.BASE_STONE_OVERWORLD)) && damageAmount > 0 && stack.getDamageValue() < stack.getMaxDamage();
    }

    @Override
    public void addEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.addEffect(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new PowerupParticleEffect(new Vector3f(0.5f, 0.5f, 0.5f), new Vector3f(0.5f, 0.5f, 0.5f), 1.0f, 1, 0.0f), (double)((float)pos.getX() + player.getRandom().nextFloat()), (double)((float)pos.getY() + player.getRandom().nextFloat()), (double)((float)pos.getZ() + player.getRandom().nextFloat()), 0.0, 0.0, 0.0);
        }
        level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundInit.GEOMENDING_BREAK.get(), SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
    }

    @Override
    public int getColor() {
        return 0x808080;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.geomending");
    }
}

