/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import org.joml.Vector3f;

public class IlluminationTrait
extends Trait {
    @Override
    public void traitAction(Player player, Level level, Entity target, Vec3 lookingPos, ItemStack stack, int traitLevel, ToolStats stats, InteractionHand hand, boolean isHost) {
        super.traitAction(player, level, target, lookingPos, stack, traitLevel, stats, hand, isHost);
        Vec3 max = player.getEyePosition().add(player.getLookAngle().scale(player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue() * (double)traitLevel));
        BlockHitResult result = level.clip(new ClipContext(player.getEyePosition(), max, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos pos = result.getBlockPos();
        Direction direction = result.getDirection();
        BlockPos placePos = pos.relative(direction);
        if (result.getType() == HitResult.Type.BLOCK && level.getBlockState(placePos).isAir()) {
            if (!level.isClientSide() && !isHost) {
                stack.hurtAndBreak(5, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            level.setBlock(placePos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)), 3);
            for (int i = 0; i < 20; ++i) {
                level.addParticle((ParticleOptions)new PowerupParticleEffect(new Vector3f(1.0f, 0.8f, 0.5f), new Vector3f(1.0f, 0.6f, 0.3f), 1.0f, 1, 0.0f), (double)((float)placePos.getX() + player.getRandom().nextFloat()), (double)((float)placePos.getY() + player.getRandom().nextFloat()), (double)((float)placePos.getZ() + player.getRandom().nextFloat()), 0.0, 0.0, 0.0);
            }
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
        }
    }

    @Override
    public int getColor() {
        return 16760960;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.illumination");
    }
}

