/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.particle.particle_option.PowerupParticleEffect;
import net.stln.magitech.util.BlockUtil;
import net.stln.magitech.util.EffectUtil;
import org.joml.Vector3f;

public class PrecipitationTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        if (player.isInWater() || level.isRainingAt(player.blockPosition())) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.45f;
            Float atk = stats.getStats().get(ToolStats.ATK_STAT);
            modified.put(ToolStats.ATK_STAT, Float.valueOf(atk.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifyStatsConditional1(player, level, stack, traitLevel, stats);
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        if (player.isInWater() || level.isRainingAt(player.blockPosition())) {
            ToolStats aDefault = ToolStats.DEFAULT;
            HashMap<String, Float> modified = new HashMap<String, Float>(aDefault.getStats());
            float mul = (float)traitLevel * 0.45f;
            Float atk = stats.getStats().get(ToolStats.ATK_STAT);
            modified.put(ToolStats.ATK_STAT, Float.valueOf(atk.floatValue() * mul));
            return new ToolStats(modified, stats.getElement(), stats.getMiningLevel(), aDefault.getTier());
        }
        return super.modifySpellCasterStatsConditional1(player, level, stack, traitLevel, stats);
    }

    @Override
    public Set<BlockPos> addAdditionalBlockBreakSecond(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, Direction direction) {
        boolean flag = true;
        boolean flag2 = true;
        boolean flag3 = true;
        boolean flag4 = true;
        for (int i = 0; i < 4; ++i) {
            flag &= level.getBlockState(pos.above(i)).getBlock().equals(blockState.getBlock());
            flag2 &= level.getBlockState(pos.above(i - 1)).getBlock().equals(blockState.getBlock());
            flag3 &= level.getBlockState(pos.above(i - 2)).getBlock().equals(blockState.getBlock());
            flag4 &= level.getBlockState(pos.above(i - 3)).getBlock().equals(blockState.getBlock());
        }
        if (flag || flag2 || flag3 || flag4) {
            return BlockUtil.getConnectedBlocks(level, pos, blockState.getBlock(), traitLevel * 5);
        }
        return new HashSet<BlockPos>();
    }

    @Override
    public boolean emitEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        return !isInitial;
    }

    @Override
    public void addEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.addEffect(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new PowerupParticleEffect(new Vector3f(0.8f, 0.7f, 0.5f), new Vector3f(0.8f, 0.7f, 0.5f), 1.0f, 1, 0.0f), (double)((float)pos.getX() + player.getRandom().nextFloat()), (double)((float)pos.getY() + player.getRandom().nextFloat()), (double)((float)pos.getZ() + player.getRandom().nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tick(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, boolean isHost) {
        super.tick(player, level, stack, traitLevel, stats, isHost);
        if (player.isInWater()) {
            EffectUtil.entityEffect(level, new PowerupParticleEffect(new Vector3f(0.8f, 0.7f, 0.5f), new Vector3f(0.8f, 0.7f, 0.5f), 1.0f, 1, 0.0f), (Entity)player, 1);
        }
    }

    @Override
    public int getColor() {
        return 14725264;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.precipitation");
    }
}

