/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.mob_effect.MobEffectInit;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;
import net.stln.magitech.network.SparkTraitBeamPayload;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.SparkParticleEffect;
import net.stln.magitech.particle.particle_option.ZapParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.BlockUtil;
import net.stln.magitech.util.DataMapHelper;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.TickScheduler;
import net.stln.magitech.util.TraitMobEffectHelper;
import org.joml.Vector3f;

public class SparkTrait
extends Trait {
    @Override
    public void onDamageEntity(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, Entity target) {
        super.onDamageEntity(player, level, stack, traitLevel, stats, target);
        if (!level.isClientSide) {
            TraitMobEffectHelper.applyTraitMobEffect((LivingEntity)player, MobEffectInit.CHARGE, 40, 0);
        }
    }

    @Override
    public void onBreakBlock(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.onBreakBlock(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        if (!level.isClientSide) {
            TraitMobEffectHelper.applyTraitMobEffect((LivingEntity)player, MobEffectInit.CHARGE, 40, 0);
        }
    }

    @Override
    public void traitAction(Player player, Level level, Entity target, Vec3 lookingPos, ItemStack stack, int traitLevel, ToolStats stats, InteractionHand hand, boolean isHost) {
        super.traitAction(player, level, target, lookingPos, stack, traitLevel, stats, hand, isHost);
        if (player.hasEffect(MobEffectInit.CHARGE)) {
            for (int i = 0; i < (player.getEffect(MobEffectInit.CHARGE).getAmplifier() + 1) * 3; ++i) {
                int finalI = i;
                TickScheduler.schedule(i, () -> {
                    Vec3 forward = Vec3.directionFromRotation((Vec2)player.getRotationVector());
                    double maxReachLength = 12.0;
                    double radius = 0.1;
                    forward = forward.add((double)Mth.randomBetween((RandomSource)player.getRandom(), (float)-0.1f, (float)0.1f), (double)Mth.randomBetween((RandomSource)player.getRandom(), (float)-0.1f, (float)0.1f), (double)Mth.randomBetween((RandomSource)player.getRandom(), (float)-0.1f, (float)0.1f)).normalize();
                    Vec3 hitPos = EntityUtil.raycastBeam((Entity)player, maxReachLength, radius, forward);
                    ResourceKey<DamageType> damageType = Element.SURGE.getDamageType();
                    DamageSource elementalDamageSource = player.damageSources().source(damageType, (Entity)player);
                    Vec3 start = player.position().add(0.0, (double)player.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5)).add((double)Mth.randomBetween((RandomSource)player.getRandom(), (float)-1.0f, (float)1.0f) * (1.0 - forward.x * forward.x), (double)Mth.randomBetween((RandomSource)player.getRandom(), (float)-1.0f, (float)1.0f) * (1.0 - forward.y * forward.y), (double)Mth.randomBetween((RandomSource)player.getRandom(), (float)-1.0f, (float)1.0f) * (1.0 - forward.z * forward.z));
                    Entity target1 = EntityUtil.raycastBeamEntity((Entity)player, maxReachLength, radius);
                    if (target1 != null) {
                        float finalDamage = (float)(1.0 * (double)DataMapHelper.getElementMultiplier(target1, Element.SURGE));
                        if (target1.isAttackable()) {
                            if (target1 instanceof LivingEntity) {
                                LivingEntity livingTarget = (LivingEntity)target1;
                                if (!target1.isInvulnerableTo(elementalDamageSource)) {
                                    float targetHealth = livingTarget.getHealth();
                                    livingTarget.setLastHurtByMob((LivingEntity)player);
                                    player.awardStat(Stats.DAMAGE_DEALT, Math.round((targetHealth - livingTarget.getHealth()) * 10.0f));
                                }
                                livingTarget.invulnerableTime = 0;
                                target1.hurt(elementalDamageSource, finalDamage);
                                if (!level.isClientSide) {
                                    livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 4));
                                    livingTarget.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 100, 4));
                                }
                            }
                            player.setLastHurtMob(target1);
                        }
                    }
                    SparkTrait.addVisualEffect(level, player, start, hitPos);
                    this.playBeamSound(level, player);
                    SparkTrait.playAnim(player, level);
                    if (!level.isClientSide) {
                        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Cannot send clientbound payloads on the client");
                        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
                            if (player.getUUID() == serverPlayer.getUUID()) continue;
                            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SparkTraitBeamPayload(start, hitPos, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                }, level.isClientSide);
            }
            if (!level.isClientSide && !isHost) {
                player.removeEffect(MobEffectInit.CHARGE);
                player.addEffect(new MobEffectInstance(MobEffectInit.COOLDOWN, 240 / traitLevel, 0));
            }
        }
    }

    public static void playAnim(Player player, Level level) {
        ModifierLayer playerAnimationData;
        if (level.isClientSide && (playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(Magitech.id("animation"))) != null) {
            player.yBodyRot = player.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)0, (Ease)Ease.CONSTANT), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("spark_beam"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    public void playBeamSound(Level level, Player user) {
        level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.ARCLUME.get(), SoundSource.PLAYERS, 0.5f, 0.9f + user.getRandom().nextFloat() * 0.9f);
    }

    public static void addVisualEffect(Level level, Player user, Vec3 start, Vec3 hitPos) {
        EffectUtil.lineEffect(level, new SparkParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 0.5f, 3, 0.0f), start, hitPos, 2, false);
        level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), start.toVector3f(), 1.0f, 1, 0.0f), hitPos.x, hitPos.y, hitPos.z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.15f, 0.15f, 0.2f), new Vector3f(0.1f, 0.1f, 0.2f), start.toVector3f(), 0.5f, 1, 1.0f), hitPos.x, hitPos.y, hitPos.z, 0.0, 0.0, 0.0);
    }

    @Override
    public Set<BlockPos> addAdditionalBlockBreakFirst(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, Direction direction) {
        int amplifier = 0;
        if (player.hasEffect(MobEffectInit.CHARGE)) {
            amplifier = player.getEffect(MobEffectInit.CHARGE).getAmplifier() + 1;
            if (!level.isClientSide) {
                player.removeEffect(MobEffectInit.CHARGE);
                player.addEffect(new MobEffectInstance(MobEffectInit.COOLDOWN, 240 / traitLevel, 0));
            }
        }
        return BlockUtil.getConnectedBlocks(level, pos, blockState.getBlock(), amplifier * 5);
    }

    @Override
    public boolean emitEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        return !isInitial;
    }

    @Override
    public void addEffect(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos, int damageAmount, boolean isInitial) {
        super.addEffect(player, level, stack, traitLevel, stats, blockState, pos, damageAmount, isInitial);
        Vec3 center = pos.getCenter();
        level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), player.position().toVector3f(), 1.0f, 1, 0.0f), center.x, center.y, center.z, 0.0, 0.0, 0.0);
        level.playSound(player, pos, SoundInit.SPARK.get(), SoundSource.PLAYERS, 0.1f, 0.3f + player.getRandom().nextFloat() * 1.4f);
    }

    @Override
    public int getColor() {
        return 8446207;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.spark");
    }
}

