/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.trait;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.trait.Trait;

public class TemperatureDifferenceTrait
extends Trait {
    @Override
    public ToolStats modifyStatsConditional1(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        super.modifyStatsConditional1(player, level, stack, traitLevel, stats);
        ToolStats defaultStats = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(defaultStats.getStats());
        float mul = (float)traitLevel * 0.25f;
        if (level.isDay()) {
            modified.put(ToolStats.ATK_STAT, Float.valueOf(stats.getStats().get(ToolStats.ATK_STAT).floatValue() * mul));
            modified.put(ToolStats.DEF_STAT, Float.valueOf(stats.getStats().get(ToolStats.DEF_STAT).floatValue() * mul));
        } else {
            modified.put(ToolStats.SPD_STAT, Float.valueOf(stats.getStats().get(ToolStats.SPD_STAT).floatValue() * mul));
        }
        return new ToolStats(modified, defaultStats.getElement(), defaultStats.getMiningLevel(), defaultStats.getTier());
    }

    @Override
    public ToolStats modifySpellCasterStatsConditional3(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats) {
        super.modifySpellCasterStatsConditional3(player, level, stack, traitLevel, stats);
        ToolStats defaultStats = ToolStats.DEFAULT;
        HashMap<String, Float> modified = new HashMap<String, Float>(defaultStats.getStats());
        float mul = (float)traitLevel * 0.25f;
        if (level.isDay()) {
            modified.put(ToolStats.ATK_STAT, Float.valueOf(stats.getStats().get(ToolStats.ATK_STAT).floatValue() * mul));
            modified.put(ToolStats.DEF_STAT, Float.valueOf(stats.getStats().get(ToolStats.DEF_STAT).floatValue() * mul));
        } else {
            modified.put(ToolStats.CHG_STAT, Float.valueOf(stats.getStats().get(ToolStats.CHG_STAT).floatValue() * mul));
            modified.put(ToolStats.MNA_STAT, Float.valueOf(stats.getStats().get(ToolStats.MNA_STAT).floatValue() * mul));
        }
        return new ToolStats(modified, defaultStats.getElement(), defaultStats.getMiningLevel(), defaultStats.getTier());
    }

    @Override
    public float modifyMiningSpeed(Player player, Level level, ItemStack stack, int traitLevel, ToolStats stats, BlockState blockState, BlockPos pos) {
        float mul = !level.isDay() ? 1.0f : (float)traitLevel * 0.25f;
        Float min = stats.getStats().get(ToolStats.MIN_STAT);
        return min.floatValue() * mul;
    }

    @Override
    public int getColor() {
        return 0xFFFFC0;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"trait.magitech.temperature_difference");
    }
}

