/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.item.tool.upgrade;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.stln.magitech.item.tool.upgrade.Upgrade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeRegister {
    private static final Map<ResourceLocation, Upgrade> dictId = new LinkedHashMap<ResourceLocation, Upgrade>();
    private static final Map<ResourceLocation, Upgrade> dictSpellCasterId = new LinkedHashMap<ResourceLocation, Upgrade>();

    public static void registerId(ResourceLocation id, Upgrade upgrade) {
        dictId.put(id, upgrade);
    }

    public static void registerSpellCasterId(ResourceLocation id, Upgrade upgrade) {
        dictSpellCasterId.put(id, upgrade);
    }

    public static Upgrade getUpgrade(ResourceLocation id) {
        return dictId.get(id);
    }

    public static Map<ResourceLocation, Upgrade> getDictId() {
        return dictId;
    }

    public static Upgrade getSpellCasterUpgrade(ResourceLocation id) {
        return dictSpellCasterId.get(id);
    }

    public static Upgrade getUpgradeFromAll(ResourceLocation id) {
        return dictId.containsKey(id) ? dictId.get(id) : dictSpellCasterId.get(id);
    }

    public static Map<ResourceLocation, Upgrade> getSpellCasterDictId() {
        return dictSpellCasterId;
    }

    public static int hasUpgrade(@Nullable Upgrade upgrade) {
        for (Map.Entry<ResourceLocation, Upgrade> entry : dictId.entrySet()) {
            if (!Objects.equals(entry.getValue(), upgrade)) continue;
            return 0;
        }
        for (Map.Entry<ResourceLocation, Upgrade> entry : dictSpellCasterId.entrySet()) {
            if (!Objects.equals(entry.getValue(), upgrade)) continue;
            return 1;
        }
        return -1;
    }

    @Nullable
    public static ResourceLocation getId(@Nullable Upgrade upgrade) {
        for (Map.Entry<ResourceLocation, Upgrade> entry : dictId.entrySet()) {
            if (!Objects.equals(entry.getValue(), upgrade)) continue;
            return entry.getKey();
        }
        for (Map.Entry<ResourceLocation, Upgrade> entry : dictSpellCasterId.entrySet()) {
            if (!Objects.equals(entry.getValue(), upgrade)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    public static Optional<ResourceLocation> getOptionalId(@Nullable Upgrade upgrade) {
        return Optional.ofNullable(UpgradeRegister.getId(upgrade));
    }
}

