/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell;

import com.mojang.serialization.Codec;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.stln.magitech.Magitech;
import net.stln.magitech.MagitechRegistries;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.status.AttributeInit;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;
import net.stln.magitech.magic.charge.Charge;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.cooldown.Cooldown;
import net.stln.magitech.magic.cooldown.CooldownData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.mana.UsedHandData;
import net.stln.magitech.magic.spell.SpellLike;
import net.stln.magitech.network.ReleaseUsingSpellPayload;
import net.stln.magitech.network.UseSpellPayload;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.input.SpellRecipeInput;
import net.stln.magitech.util.DataMapHelper;
import net.stln.magitech.util.MathUtil;
import net.stln.magitech.util.SpellShape;
import org.jetbrains.annotations.NotNull;

public abstract class Spell
implements SpellLike {
    public static final Codec<Spell> CODEC = MagitechRegistries.SPELL.byNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Spell> STREAM_CODEC = ByteBufCodecs.registry(MagitechRegistries.Keys.SPELL);
    public float baseDamage = 0.0f;
    public float baseEffectStrength = 0.0f;
    public float baseDuration = 0.0f;
    public float tickBaseDamage = 0.0f;
    public double baseSpeed = 0.0;
    public double baseMaxRange = 0.0;

    @OnlyIn(value=Dist.CLIENT)
    private static void stopAnim(Player player) {
        IAnimation iAnimation;
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(Magitech.id("animation"));
        if (playerAnimationData != null && (iAnimation = playerAnimationData.getAnimation()) instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer keyframeAnimationPlayer = (KeyframeAnimationPlayer)iAnimation;
            keyframeAnimationPlayer.stop();
        }
    }

    public Element getElement() {
        return Element.NONE;
    }

    public SpellShape getSpellShape() {
        return SpellShape.SHOT;
    }

    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        return this.getBaseCost();
    }

    public Map<ManaUtil.ManaType, Double> getBaseCost() {
        return new HashMap<ManaUtil.ManaType, Double>();
    }

    public Map<ManaUtil.ManaType, Double> getBaseTickCost() {
        return new HashMap<ManaUtil.ManaType, Double>();
    }

    public Map<ManaUtil.ManaType, Double> getRequiredMana(Level level, Player user, ItemStack stack) {
        HashMap<ManaUtil.ManaType, Double> map = new HashMap<ManaUtil.ManaType, Double>(this.getBaseRequiredMana());
        if (map.containsKey((Object)ManaUtil.ManaType.MANA)) {
            map.put(ManaUtil.ManaType.MANA, (Double)map.get((Object)ManaUtil.ManaType.MANA) / user.getAttributeValue(AttributeInit.MANA_EFFICIENCY));
        }
        return map;
    }

    public Map<ManaUtil.ManaType, Double> getCost(Level level, Player user, ItemStack stack) {
        HashMap<ManaUtil.ManaType, Double> map = new HashMap<ManaUtil.ManaType, Double>(this.getBaseCost());
        if (map.containsKey((Object)ManaUtil.ManaType.MANA)) {
            map.put(ManaUtil.ManaType.MANA, (Double)map.get((Object)ManaUtil.ManaType.MANA) / user.getAttributeValue(AttributeInit.MANA_EFFICIENCY));
        }
        return map;
    }

    public Map<ManaUtil.ManaType, Double> getTickCost(Level level, Player user, ItemStack stack) {
        HashMap<ManaUtil.ManaType, Double> map = new HashMap<ManaUtil.ManaType, Double>(this.getBaseTickCost());
        if (map.containsKey((Object)ManaUtil.ManaType.MANA)) {
            map.put(ManaUtil.ManaType.MANA, (Double)map.get((Object)ManaUtil.ManaType.MANA) / user.getAttributeValue(AttributeInit.MANA_EFFICIENCY));
        }
        return map;
    }

    public boolean needsUseCost(Level level, Player user, ItemStack stack) {
        return true;
    }

    public boolean needsTickCost(Level level, Player user, ItemStack stack) {
        return true;
    }

    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 60;
    }

    public int getModifiedCooldown(Level level, Player user, ItemStack stack) {
        return (int)Math.round((double)this.getCooldown(level, user, stack) / user.getAttributeValue(AttributeInit.COOLDOWN_SPEED));
    }

    public Element getElement(Level level, Player user, ItemStack stack) {
        return Element.NONE;
    }

    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        if (level.isClientSide) {
            this.playAnimation(user);
            if (isHost) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UseSpellPayload(hand == InteractionHand.MAIN_HAND, user.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (this.canHoldUsing()) {
            user.startUsingItem(hand);
        }
        UsedHandData.setUsedHand(user, hand == InteractionHand.OFF_HAND ^ user.getMainArm() == HumanoidArm.LEFT);
        ItemStack stack = user.getItemInHand(hand);
        if (!level.isClientSide && isHost) {
            stack.hurtAndBreak(1, (LivingEntity)user, LivingEntity.getSlotForHand((InteractionHand)hand));
            SpellCasterItem.progress(stack, user.level(), (Entity)user);
        }
    }

    public boolean isActiveUse(Level level, Player user, InteractionHand hand, boolean isHost) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.setAnimation((IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("swing_wand"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    public boolean canHoldUsing() {
        return false;
    }

    public boolean stopAnimOnRelease() {
        return true;
    }

    public boolean releaseOnCharged() {
        return true;
    }

    public void usingTick(Level level, LivingEntity livingEntity, ItemStack stack, int usingTick) {
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            InteractionHand hand = user.getItemInHand(InteractionHand.MAIN_HAND) == stack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            UsedHandData.setUsedHand(user, hand == InteractionHand.OFF_HAND ^ user.getMainArm() == HumanoidArm.LEFT);
        }
    }

    public boolean isActiveUsingTick(Level level, LivingEntity livingEntity, ItemStack stack, int usingTick) {
        return true;
    }

    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        Player player;
        Charge charge;
        if (livingEntity instanceof Player && (charge = ChargeData.getCurrentCharge(player = (Player)livingEntity)) != null && (charge.getCharge() >= charge.getMaxCharge() || (double)timeCharged >= charge.getMaxCharge())) {
            ChargeData.removeCharge(player);
        }
        if (isHost && level.isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ReleaseUsingSpellPayload(stack, timeCharged, livingEntity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (level.isClientSide && this.canHoldUsing() && livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (this.stopAnimOnRelease()) {
                Spell.stopAnim(player);
            }
        }
        if (!isHost) {
            livingEntity.stopUsingItem();
        }
    }

    public void addCharge(Player user, int ticks, Element element) {
        ChargeData.setCurrentCharge(user, new Charge(Math.max(Math.round((double)ticks / user.getAttributeValue(AttributeInit.CASTING_SPEED)), 2L), this, element));
    }

    public void addCooldown(Level level, Player user, ItemStack stack) {
        CooldownData.addCurrentCooldown(user, this, new Cooldown((double)this.getCooldown(level, user, stack) / user.getAttributeValue(AttributeInit.COOLDOWN_SPEED), this.getElement()));
    }

    public float getDamage(Player user, Map<ManaUtil.ManaType, Double> cost, float baseDamage, Element element) {
        double elementPower;
        baseDamage = ManaUtil.checkStrandDamageMul(user, cost, baseDamage);
        double power = user.getAttributeValue(AttributeInit.SPELL_POWER);
        if (element != Element.NONE) {
            DeferredHolder<Attribute, Attribute> elementAttribute = switch (element) {
                case Element.EMBER -> AttributeInit.EMBER_SPELL_POWER;
                case Element.GLACE -> AttributeInit.GLACE_SPELL_POWER;
                case Element.SURGE -> AttributeInit.SURGE_SPELL_POWER;
                case Element.PHANTOM -> AttributeInit.PHANTOM_SPELL_POWER;
                case Element.TREMOR -> AttributeInit.TREMOR_SPELL_POWER;
                case Element.MAGIC -> AttributeInit.MAGIC_SPELL_POWER;
                case Element.FLOW -> AttributeInit.FLOW_SPELL_POWER;
                case Element.HOLLOW -> AttributeInit.HOLLOW_SPELL_POWER;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)element));
            };
            elementPower = user.getAttributeValue(elementAttribute);
        } else {
            elementPower = 1.0;
        }
        return (float)((double)baseDamage * power + (double)baseDamage * (elementPower - 1.0));
    }

    public double getProjectileSpeed(Player user, double baseSpeed) {
        double power = user.getAttributeValue(AttributeInit.PROJECTILE_SPEED);
        return baseSpeed * power;
    }

    public void applyDamage(float baseDamage, Map<ManaUtil.ManaType, Double> cost, Element element, ItemStack stack, Player user, Entity target) {
        float damage = this.getDamage(user, cost, baseDamage, element);
        ResourceKey<DamageType> damageType = element.getDamageType();
        DamageSource elementalDamageSource = user.damageSources().source(damageType, (Entity)user);
        if (target.isAttackable()) {
            damage *= DataMapHelper.getElementMultiplier(target, element);
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (livingTarget.invulnerableTime < 10) {
                    Item item = stack.getItem();
                    if (item instanceof SpellCasterItem) {
                        SpellCasterItem spellCasterItem = (SpellCasterItem)item;
                        spellCasterItem.callTraitSpellHitEntity(user.level(), user, target, stack);
                    }
                    if (!target.isInvulnerableTo(elementalDamageSource)) {
                        float targetHealth = livingTarget.getHealth();
                        livingTarget.setLastHurtByMob((LivingEntity)user);
                        user.awardStat(Stats.DAMAGE_DEALT, Math.round((targetHealth - livingTarget.getHealth()) * 10.0f));
                    }
                    target.hurt(elementalDamageSource, damage);
                }
            }
            user.setLastHurtMob(target);
        }
    }

    public List<Component> getTooltip(Level level, Player user, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)this.getElement().getSpellElementName().withColor(this.getElement().getSpellColor()).append((Component)Component.literal((String)" ").append((Component)Component.translatable((String)("spell_shape.magitech." + this.getSpellShape().get())).withColor(this.getSpellShape().getDark()))));
        if (this.baseDamage != 0.0f) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.damage").append(": " + MathUtil.round(this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), this.baseDamage, this.getElement()), 2)));
        }
        if (this.tickBaseDamage != 0.0f) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.tick_damage").append(": " + MathUtil.round(this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), this.tickBaseDamage, this.getElement()), 2)));
        }
        if (this.baseSpeed != 0.0) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.projectile_speed").append(": " + MathUtil.round(this.getProjectileSpeed(user, this.baseSpeed), 2)));
        }
        if (this.baseEffectStrength != 0.0f) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.effect_strength").append(": " + MathUtil.round(this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), this.baseEffectStrength, this.getElement()), 2)));
        }
        if (this.baseDuration != 0.0f) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.duration").append(": " + MathUtil.round(this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), this.baseDuration, this.getElement()), 2)));
        }
        if (this.baseMaxRange != 0.0) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.max_range").append(": " + MathUtil.round(this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), 2)));
        }
        list.add((Component)Component.translatable((String)"tooltip.magitech.spell.cooldown").append(": " + MathUtil.round((double)this.getModifiedCooldown(level, user, stack) / 20.0, 2) + "s"));
        list.add((Component)Component.empty());
        if (this.getBaseRequiredMana().containsKey((Object)ManaUtil.ManaType.MANA) && !Objects.equals(this.getBaseRequiredMana().get((Object)ManaUtil.ManaType.MANA), this.getBaseCost().get((Object)ManaUtil.ManaType.MANA))) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.required_mana").append(": " + MathUtil.round(this.getRequiredMana(level, user, stack).get((Object)ManaUtil.ManaType.MANA), 2)).withColor(0x40FFF0));
        }
        if (this.needsUseCost(level, user, stack) && this.getBaseCost().containsKey((Object)ManaUtil.ManaType.MANA)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.use_cost_mana").append(": " + MathUtil.round(this.getCost(level, user, stack).get((Object)ManaUtil.ManaType.MANA), 2)).withColor(0x40FFF0));
        }
        if (this.needsTickCost(level, user, stack) && this.canHoldUsing() && this.getBaseTickCost().containsKey((Object)ManaUtil.ManaType.MANA)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.tick_cost_mana").append(": " + MathUtil.round(this.getTickCost(level, user, stack).get((Object)ManaUtil.ManaType.MANA), 2) + "/tick").withColor(0x40FFF0));
        }
        if (this.getBaseRequiredMana().containsKey((Object)ManaUtil.ManaType.NOCTIS) && !Objects.equals(this.getBaseRequiredMana().get((Object)ManaUtil.ManaType.NOCTIS), this.getBaseCost().get((Object)ManaUtil.ManaType.NOCTIS))) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.required_noctis").append(": " + MathUtil.round(this.getRequiredMana(level, user, stack).get((Object)ManaUtil.ManaType.NOCTIS), 2)).withColor(6303872));
        }
        if (this.needsUseCost(level, user, stack) && this.getBaseCost().containsKey((Object)ManaUtil.ManaType.NOCTIS)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.use_cost_noctis").append(": " + MathUtil.round(this.getCost(level, user, stack).get((Object)ManaUtil.ManaType.NOCTIS), 2)).withColor(6303872));
        }
        if (this.needsTickCost(level, user, stack) && this.canHoldUsing() && this.getBaseTickCost().containsKey((Object)ManaUtil.ManaType.NOCTIS)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.tick_cost_noctis").append(": " + MathUtil.round(this.getTickCost(level, user, stack).get((Object)ManaUtil.ManaType.NOCTIS), 2) + "/tick").withColor(6303872));
        }
        if (this.getBaseRequiredMana().containsKey((Object)ManaUtil.ManaType.LUMINIS) && !Objects.equals(this.getBaseRequiredMana().get((Object)ManaUtil.ManaType.LUMINIS), this.getBaseCost().get((Object)ManaUtil.ManaType.LUMINIS))) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.required_luminis").append(": " + MathUtil.round(this.getRequiredMana(level, user, stack).get((Object)ManaUtil.ManaType.LUMINIS), 2)).withColor(0xFFFFC0));
        }
        if (this.needsUseCost(level, user, stack) && this.getBaseCost().containsKey((Object)ManaUtil.ManaType.LUMINIS)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.use_cost_luminis").append(": " + MathUtil.round(this.getCost(level, user, stack).get((Object)ManaUtil.ManaType.LUMINIS), 2)).withColor(0xFFFFC0));
        }
        if (this.needsTickCost(level, user, stack) && this.canHoldUsing() && this.getBaseTickCost().containsKey((Object)ManaUtil.ManaType.LUMINIS)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.tick_cost_luminis").append(": " + MathUtil.round(this.getTickCost(level, user, stack).get((Object)ManaUtil.ManaType.LUMINIS), 2) + "/tick").withColor(0xFFFFC0));
        }
        if (this.getBaseRequiredMana().containsKey((Object)ManaUtil.ManaType.FLUXIA) && !Objects.equals(this.getBaseRequiredMana().get((Object)ManaUtil.ManaType.FLUXIA), this.getBaseCost().get((Object)ManaUtil.ManaType.FLUXIA))) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.required_fluxia").append(": " + MathUtil.round(this.getRequiredMana(level, user, stack).get((Object)ManaUtil.ManaType.FLUXIA), 2)).withColor(12640511));
        }
        if (this.needsUseCost(level, user, stack) && this.getBaseCost().containsKey((Object)ManaUtil.ManaType.FLUXIA)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.use_cost_fluxia").append(": " + MathUtil.round(this.getCost(level, user, stack).get((Object)ManaUtil.ManaType.FLUXIA), 2)).withColor(12640511));
        }
        if (this.needsTickCost(level, user, stack) && this.canHoldUsing() && this.getBaseTickCost().containsKey((Object)ManaUtil.ManaType.FLUXIA)) {
            list.add((Component)Component.translatable((String)"tooltip.magitech.spell.tick_cost_fluxia").append(": " + MathUtil.round(this.getTickCost(level, user, stack).get((Object)ManaUtil.ManaType.FLUXIA), 2) + "/tick").withColor(12640511));
        }
        return list;
    }

    protected void applyEffectToItem(Level level, Player user, Entity target) {
        if (target instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)target;
            SpellRecipeInput recipeInput = new SpellRecipeInput(item.getItem(), this);
            level.getRecipeManager().getRecipeFor(RecipeInit.SPELL_CONVERSION_TYPE.get(), (RecipeInput)recipeInput, level).map(RecipeHolder::value).ifPresent(recipe -> {
                int spawnCount;
                ItemStack stack = recipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
                for (int count = item.getItem().getCount() * stack.getCount(); count > 0; count -= spawnCount) {
                    spawnCount = Math.min(stack.getMaxStackSize(), count);
                    ItemStack result = stack.copy();
                    result.setCount(spawnCount);
                    ItemEntity newItem = new ItemEntity(level, item.getX(), item.getY(), item.getZ(), result, (double)Mth.nextFloat((RandomSource)item.getRandom(), (float)-0.3f, (float)0.3f), 0.3, (double)Mth.nextFloat((RandomSource)item.getRandom(), (float)-0.3f, (float)0.3f));
                    level.addFreshEntity((Entity)newItem);
                }
                item.discard();
            });
        }
    }

    @Override
    @NotNull
    public Spell asSpell() {
        return this;
    }

    @NotNull
    public ResourceLocation getId() {
        return Objects.requireNonNull(MagitechRegistries.SPELL.getKey((Object)this));
    }

    @NotNull
    public String getDescriptionId() {
        return this.getId().toLanguageKey("spell");
    }

    @NotNull
    public MutableComponent getDescription() {
        return Component.translatable((String)this.getDescriptionId());
    }

    @NotNull
    public ResourceLocation getIconId() {
        return this.getId().withPrefix("textures/spell/").withSuffix(".png");
    }
}

