/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.flow;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.particle.particle_option.BlowParticleEffect;
import net.stln.magitech.particle.particle_option.SquareFieldParticleEffect;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.SpellShape;
import org.joml.Vector3f;

public class Nymphora
extends Spell {
    public Nymphora() {
        this.baseEffectStrength = 4.0f;
    }

    protected static void playShootAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (Ease)Ease.OUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_shoot"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    @Override
    public Element getElement() {
        return Element.FLOW;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.RESILIENCE;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 60.0);
        cost.put(ManaUtil.ManaType.LUMINIS, 9.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 300;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 20, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                Vec3 userPos = user.position();
                level.addParticle((ParticleOptions)new SquareFieldParticleEffect(new Vector3f(0.7f, 1.0f, 0.0f), new Vector3f(0.9f, 1.0f, 0.0f), 1.0f, 1, 0.0f), user.getX(), user.getY() + 0.1, user.getZ(), 0.0, 0.0, 0.0);
                for (int i = 0; i < 20; ++i) {
                    level.addParticle((ParticleOptions)new BlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), userPos.x, userPos.y, userPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 6.0, ((double)user.getRandom().nextFloat() - 0.5) / 6.0 + 0.1, ((double)user.getRandom().nextFloat() - 0.5) / 6.0);
                    level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.7f, 1.0f, 0.0f), new Vector3f(0.9f, 1.0f, 0.0f), 1.0f, user.getRandom().nextInt(5, 7), (float)(((double)user.getRandom().nextFloat() - 0.5) / 10.0)), userPos.x, userPos.y, userPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 6.0, ((double)user.getRandom().nextFloat() - 0.5) / 6.0 + 0.1, ((double)user.getRandom().nextFloat() - 0.5) / 6.0);
                }
                EffectUtil.entityEffect(level, () -> new SquareParticleEffect(new Vector3f(0.7f, 1.0f, 0.0f), new Vector3f(0.9f, 1.0f, 0.0f), 0.75f, user.getRandom().nextInt(5, 7), (float)(((double)user.getRandom().nextFloat() - 0.5) / 10.0)), () -> new Vec3(0.0, (double)(user.getRandom().nextFloat() / 8.0f), 0.0), (Entity)user, 10);
                EffectUtil.entityEffect(level, () -> new BlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 0, 0.0f), () -> new Vec3(0.0, (double)(user.getRandom().nextFloat() / 8.0f), 0.0), (Entity)user, 10);
                level.playSound(user, userPos.x, userPos.y, userPos.z, SoundInit.NYMPHORA.get(), SoundSource.PLAYERS, 1.0f, 0.7f + user.getRandom().nextFloat() * 0.6f);
                if (level.isClientSide) {
                    Nymphora.playShootAnimation(user);
                }
                if (!level.isClientSide) {
                    user.heal(this.getDamage(user, this.getRequiredMana(level, user, stack), this.baseEffectStrength, this.getElement()));
                }
                this.addCooldown(level, user, stack);
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    @Override
    public boolean canHoldUsing() {
        return true;
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)3, (Ease)Ease.OUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_chant"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

