/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.glace;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.BeamSpell;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.FrostParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.SpellShape;
import org.joml.Vector3f;

public class Cryoluxa
extends BeamSpell {
    public Cryoluxa() {
        this.baseDamage = 8.0f;
        this.baseMaxRange = 63.0;
        this.beamradius = 0.3;
    }

    @Override
    public Element getElement() {
        return Element.GLACE;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.BEAM;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 50.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 4.0);
        cost.put(ManaUtil.ManaType.FLUXIA, 3.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 120;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 4, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
    }

    @Override
    protected void applyEffectToLivingTarget(Level level, Player user, LivingEntity target) {
        super.applyEffectToLivingTarget(level, user, target);
        target.setTicksFrozen(Math.min(target.getTicksFrozen() + 160, 300));
    }

    @Override
    protected void playBeamSound(Level level, Player user) {
        level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.FROST_BREAK.get(), SoundSource.PLAYERS, 1.0f, 0.6f + user.getRandom().nextFloat() * 0.6f);
    }

    @Override
    protected void addVisualEffect(Level level, Player user, Vec3 start, Vec3 hitPos) {
        EffectUtil.lineEffect(level, new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), start, hitPos, 2, false);
        level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.6f, 1.0f, 1.0f), hitPos.toVector3f(), 0.7f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new FrostParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), hitPos.x, hitPos.y, hitPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
        }
    }
}

