/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.glace;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.magicentity.frigala.FrigalaEntity;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.cooldown.CooldownData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.SpellShape;

public class Frigala
extends Spell {
    public Frigala() {
        this.baseDamage = 8.0f;
        this.baseSpeed = 1.5;
    }

    private static void playShootAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (Ease)Ease.INSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("swing_wand"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    @Override
    public Element getElement() {
        return Element.GLACE;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.SHOT;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 55.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 5.0);
        cost.put(ManaUtil.ManaType.FLUXIA, 3.0);
        return cost;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 25, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public boolean isActiveUse(Level level, Player user, InteractionHand hand, boolean isHost) {
        return CooldownData.getCurrentCooldown(user, this) == null;
    }

    @Override
    public boolean canHoldUsing() {
        return true;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 60;
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.GLACE_LAUNCH.get(), SoundSource.PLAYERS);
                if (!level.isClientSide && !isHost) {
                    FrigalaEntity bullet = new FrigalaEntity(level, user, stack, this.getDamage(user, this.getRequiredMana(level, user, stack), this.baseDamage, this.getElement()));
                    Vec3 velocity = Vec3.directionFromRotation((Vec2)user.getRotationVector());
                    velocity = velocity.normalize().scale(this.getProjectileSpeed(user, this.baseSpeed));
                    bullet.setDeltaMovement(velocity);
                    bullet.setPos(user.getX(), user.getEyeY() - 0.3, user.getZ());
                    level.addFreshEntity((Entity)bullet);
                }
                if (level.isClientSide) {
                    Frigala.playShootAnimation(user);
                }
                this.addCooldown(level, user, stack);
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (Ease)Ease.INSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("charge_wand"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

