/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.hollow;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.particle.particle_option.VoidGlowParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.SpellShape;
import org.joml.Vector3f;

public class Tenebrisol
extends Spell {
    public Tenebrisol() {
        this.tickBaseDamage = 5.0f;
    }

    @Override
    public Element getElement() {
        return Element.HOLLOW;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.SPRAY;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 45.0);
        return cost;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseCost() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 35.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 5.0);
        return cost;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseTickCost() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 1.5);
        cost.put(ManaUtil.ManaType.NOCTIS, 2.0);
        return cost;
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)3, (Ease)Ease.INSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_spray"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    @Override
    public boolean canHoldUsing() {
        return true;
    }

    @Override
    public boolean releaseOnCharged() {
        return false;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 50;
    }

    @Override
    public void usingTick(Level level, LivingEntity livingEntity, ItemStack stack, int usingTick) {
        super.usingTick(level, livingEntity, stack, usingTick);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Vec3 forward = Vec3.directionFromRotation((Vec2)livingEntity.getRotationVector());
            Vec3 bodyPos = livingEntity.position().add(0.0, (double)livingEntity.getBbHeight() * 0.7, 0.0);
            Vec3 offset = bodyPos.add(forward.scale(1.0));
            Vec3 center = livingEntity.getEyePosition().add(forward);
            Vec3 center2 = center.add(forward.scale(2.0));
            HashSet<Entity> attackList = new HashSet<Entity>();
            attackList.addAll(EntityUtil.getEntitiesInBox(level, (Entity)livingEntity, center, new Vec3(3.0, 3.0, 3.0)));
            attackList.addAll(EntityUtil.getEntitiesInBox(level, (Entity)livingEntity, center2, new Vec3(4.0, 4.0, 4.0)));
            for (int i = 0; i < 5; ++i) {
                level.addParticle((ParticleOptions)new VoidGlowParticleEffect(new Vector3f(1.0f), new Vector3f(1.0f), 5.0f, 1, 0.0f), offset.x + ((double)livingEntity.getRandom().nextFloat() - 0.5) / 4.0, offset.y + ((double)livingEntity.getRandom().nextFloat() - 0.5) / 4.0, offset.z + ((double)livingEntity.getRandom().nextFloat() - 0.5) / 4.0, forward.x * 0.5 + ((double)livingEntity.getRandom().nextFloat() - 0.5) / 2.0, forward.y * 0.5 + ((double)livingEntity.getRandom().nextFloat() - 0.5) / 2.0, forward.z * 0.5 + ((double)livingEntity.getRandom().nextFloat() - 0.5) / 2.0);
            }
            if (usingTick % 5 == 0) {
                level.playSound(player, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundInit.TENEBRISOL.get(), SoundSource.PLAYERS, 1.0f, 0.7f + player.getRandom().nextFloat() * 0.6f);
            }
            for (Entity target : attackList) {
                Vec3 targetBodyPos;
                if (!target.isAttackable() || level.clip(new ClipContext(targetBodyPos = target.position().add(0.0, (double)target.getBbHeight() * 0.7, 0.0), offset, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity)).getType() == HitResult.Type.BLOCK) continue;
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 1));
                }
                if (!(livingEntity instanceof Player)) continue;
                Player user = (Player)livingEntity;
                this.applyDamage(this.tickBaseDamage, this.getTickCost(level, user, stack), this.getElement(), stack, user, target);
            }
        }
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            this.addCooldown(level, user, stack);
        }
    }
}

