/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.hollow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.mob_effect.MobEffectInit;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.BeamSpell;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.VoidGlowParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.SpellShape;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;

public class Voidlance
extends BeamSpell {
    public Voidlance() {
        this.baseDamage = 7.0f;
        this.baseMaxRange = 63.0;
        this.beamradius = 0.1;
    }

    @Override
    public Element getElement() {
        return Element.HOLLOW;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.BEAM;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 40.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 6.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 120;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 4, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        this.callSuperFinishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                Vec3 forward = Vec3.directionFromRotation((Vec2)user.getRotationVector());
                Vec3 hitPos = EntityUtil.raycastBeam((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                Entity target = EntityUtil.raycastBeamEntity((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                Vec3 start = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5));
                this.addVisualEffect(level, user, start, hitPos);
                this.playBeamSound(level, user);
                List[] vec3s = new List[]{new ArrayList()};
                TickScheduler.schedule(2, () -> {
                    vec3s[0] = this.addBeam(stack, level, user, hitPos, 1);
                }, level.isClientSide);
                TickScheduler.schedule(4, () -> {
                    for (Vec3 hit : vec3s[0]) {
                        this.addBeam(stack, level, user, hit, 2);
                    }
                }, level.isClientSide);
                if (!level.isClientSide) {
                    if (target instanceof LivingEntity) {
                        LivingEntity livingTarget = (LivingEntity)target;
                        this.applyEffectToLivingTarget(level, user, livingTarget);
                    }
                    if (target != null) {
                        this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, target);
                    }
                }
                this.addCooldown(level, user, stack);
                if (level.isClientSide) {
                    Voidlance.playShootAnimation(user);
                }
                this.addCooldown(level, user, stack);
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    public List<Vec3> addBeam(ItemStack stack, Level level, Player user, Vec3 hitPos, int order) {
        ArrayList<Vec3> vec3s = new ArrayList<Vec3>();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1) continue;
                    Vec3 dir = new Vec3((double)i, (double)j, (double)k).normalize();
                    Vec3 hit = EntityUtil.raycastBeam(user, 24.0 / Math.pow(order, 2.0), hitPos.add(dir.scale(0.5)), dir, this.beamradius);
                    Entity target = EntityUtil.raycastBeamEntity(user, 24.0 / Math.pow(order, 2.0), hitPos.add(dir.scale(0.5)), dir, this.beamradius);
                    Vec3 start = hitPos.add(dir.scale(0.5));
                    EffectUtil.lineEffect(level, new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), start, hit, 2, false);
                    level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.3f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), hit.toVector3f(), 0.7f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
                    for (int l = 0; l < 20; ++l) {
                        level.addParticle((ParticleOptions)new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), hit.x, hit.y, hit.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
                    }
                    if (!level.isClientSide) {
                        if (target instanceof LivingEntity) {
                            LivingEntity livingTarget = (LivingEntity)target;
                            livingTarget.addEffect(new MobEffectInstance(MobEffectInit.VOIDROT, 80, 0), (Entity)livingTarget);
                        }
                        if (target != null) {
                            this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, target);
                        }
                    }
                    vec3s.add(hit);
                }
            }
        }
        level.playSound(user, hitPos.x(), hitPos.y(), hitPos.z(), SoundInit.VOIDLANCE.get(), SoundSource.PLAYERS, 1.0f, 0.6f + user.getRandom().nextFloat() * 0.6f);
        return vec3s;
    }

    @Override
    protected void applyEffectToLivingTarget(Level level, Player user, LivingEntity target) {
        super.applyEffectToLivingTarget(level, user, target);
        target.addEffect(new MobEffectInstance(MobEffectInit.VOIDROT, 80, 0), (Entity)target);
    }

    @Override
    protected void playBeamSound(Level level, Player user) {
        level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.VOIDLANCE.get(), SoundSource.PLAYERS, 1.0f, 0.6f + user.getRandom().nextFloat() * 0.6f);
    }

    @Override
    protected void addVisualEffect(Level level, Player user, Vec3 start, Vec3 hitPos) {
        EffectUtil.lineEffect(level, new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), start, hitPos, 2, false);
        level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.3f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), hitPos.toVector3f(), 0.7f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new VoidGlowParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), hitPos.x, hitPos.y, hitPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
        }
    }
}

