/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.surge;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.particle.particle_option.SparkParticleEffect;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import net.stln.magitech.particle.particle_option.ZapParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.SpellShape;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;

public class Arclume
extends Spell {
    public Arclume() {
        this.baseDamage = 7.0f;
        this.baseMaxRange = 10.0;
    }

    @Override
    public Element getElement() {
        return Element.SURGE;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.DASH;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseCost() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 55.0);
        cost.put(ManaUtil.ManaType.LUMINIS, 6.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 1.5);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 60;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        super.use(level, user, hand, isHost);
        ItemStack stack = user.getItemInHand(hand);
        Vec3 forward = Vec3.directionFromRotation((Vec2)user.getRotationVector());
        Vec3 hitPos = EntityUtil.raycast(user, this.getDamage(user, this.getRequiredMana(level, user, stack), (float)this.baseMaxRange, this.getElement())).subtract(forward.scale((double)(user.getBbWidth() / 2.0f) + 0.1));
        Vec3 start = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5));
        EffectUtil.lineEffect(level, new SparkParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 3, 0.0f), start, hitPos, 2, false);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)new SparkParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 3, 0.0f), hitPos.x, hitPos.y, hitPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
        }
        level.playSound(user, hitPos.x, hitPos.y, hitPos.z, SoundInit.ARCLUME.get(), SoundSource.PLAYERS, 1.0f, 1.0f + user.getRandom().nextFloat() * 0.6f);
        Vec3 oldPos = new Vec3(user.position().toVector3f());
        int i = 0;
        while ((double)i < hitPos.subtract(oldPos).length() / 2.0) {
            int finalI = i;
            TickScheduler.schedule(i * 2, () -> this.addLightning(stack, user, level, oldPos.lerp(hitPos, (double)finalI / hitPos.subtract(oldPos).length() * 2.0)), level.isClientSide);
            ++i;
        }
        if (isHost) {
            user.setPos(hitPos);
        }
        user.fallDistance = 0.0f;
        this.addCooldown(level, user, stack);
    }

    private void addLightning(ItemStack stack, Player user, Level level, Vec3 pos) {
        Vec3 surface = EntityUtil.findSurface(level, pos);
        Vec3 lightningTop = surface.add(0.0, (double)Mth.randomBetween((RandomSource)user.getRandom(), (float)5.0f, (float)20.0f), 0.0);
        List<Entity> entities = EntityUtil.getEntitiesInBox(level, (Entity)user, surface, new Vec3(2.0, 2.0, 2.0));
        level.playSound(user, surface.x, surface.y, surface.z, SoundInit.ARCLUME.get(), SoundSource.PLAYERS, 1.0f, 0.8f + user.getRandom().nextFloat() * 0.6f);
        if (!level.isClientSide) {
            for (Entity target : entities) {
                this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, target);
            }
        }
        if (level.isClientSide) {
            double vz;
            double vy;
            double vx;
            double z;
            double y;
            double x;
            int twinkle;
            int i;
            level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f), new Vector3f(1.0f), lightningTop.toVector3f(), 2.0f, 3, 0.0f), surface.x, surface.y, surface.z, 0.0, 0.0, 0.0);
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(0.5f, 0.5f, 1.0f);
            float scale = 1.0f;
            float rotSpeed = 0.0f;
            int particleAmount = 20;
            for (i = 0; i < particleAmount; ++i) {
                twinkle = user.getRandom().nextInt(2, 4);
                x = lightningTop.x;
                y = lightningTop.y;
                z = lightningTop.z;
                vx = ((double)user.getRandom().nextFloat() - 0.5) / 10.0;
                vy = ((double)user.getRandom().nextFloat() - 0.5) / 10.0;
                vz = ((double)user.getRandom().nextFloat() - 0.5) / 10.0;
                level.addParticle((ParticleOptions)new SquareParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
            for (i = 0; i < particleAmount; ++i) {
                twinkle = user.getRandom().nextInt(2, 4);
                x = surface.x + (double)Mth.randomBetween((RandomSource)user.getRandom(), (float)-0.2f, (float)0.2f);
                y = surface.y + (double)Mth.randomBetween((RandomSource)user.getRandom(), (float)-0.2f, (float)0.2f);
                z = surface.z + (double)Mth.randomBetween((RandomSource)user.getRandom(), (float)-0.2f, (float)0.2f);
                vx = ((double)user.getRandom().nextFloat() - 0.5) / 2.0;
                vy = (double)user.getRandom().nextFloat() - 0.5;
                vz = ((double)user.getRandom().nextFloat() - 0.5) / 2.0;
                level.addParticle((ParticleOptions)new UnstableSquareParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        }
    }

    @Override
    public boolean canHoldUsing() {
        return false;
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (Ease)Ease.OUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_blink"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

