/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.surge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.status.AttributeInit;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.BeamSpell;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.SparkParticleEffect;
import net.stln.magitech.particle.particle_option.ZapParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.SpellShape;
import net.stln.magitech.util.TickScheduler;
import org.joml.Vector3f;

public class Fulgenza
extends BeamSpell {
    public Fulgenza() {
        this.baseDamage = 18.0f;
        this.baseMaxRange = 63.0;
        this.beamradius = 1.0;
    }

    @Override
    public Element getElement() {
        return Element.SURGE;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.BEAM;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 85.0);
        cost.put(ManaUtil.ManaType.LUMINIS, 10.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 5.0);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 200;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 80, this.getElement());
        int delay = (int)Math.round(80.0 / user.getAttributeValue(AttributeInit.CASTING_SPEED)) - 80;
        TickScheduler.schedule(Math.max(delay, 0), () -> level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.FULGENZA_CHARGE.get(), SoundSource.PLAYERS, 1.0f, 80.0f / (float)(Math.round(80.0 / user.getAttributeValue(AttributeInit.CASTING_SPEED)) - (long)Math.max(delay, 0))), level.isClientSide);
        super.use(level, user, hand, isHost);
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        this.callSuperFinishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                Vec3 forward = Vec3.directionFromRotation((Vec2)user.getRotationVector());
                Vec3 hitPos = EntityUtil.raycastBeam((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                Entity target = EntityUtil.raycastBeamEntity((Entity)user, this.getDamage(user, new HashMap<ManaUtil.ManaType, Double>(), (float)this.baseMaxRange, this.getElement()), this.beamradius);
                Vec3 start = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5));
                this.addVisualEffect(level, user, start, hitPos);
                this.playBeamSound(level, user);
                if (target != null) {
                    if (!level.isClientSide) {
                        this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, target);
                    }
                    HashSet<Entity> attackList = new HashSet<Entity>();
                    attackList.addAll(EntityUtil.getEntitiesInBox(level, (Entity)livingEntity, hitPos, new Vec3(12.0, 12.0, 12.0)));
                    attackList.remove(target);
                    for (Entity chainTarget : attackList) {
                        Vec3 targetBodyPos = chainTarget.position().add(0.0, (double)chainTarget.getBbHeight() * 0.7, 0.0);
                        if (level.clip(new ClipContext(targetBodyPos, target.position().add(0.0, (double)target.getBbHeight() * 0.7, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity)).getType() == HitResult.Type.BLOCK) continue;
                        if (!level.isClientSide) {
                            this.applyDamage(this.baseDamage / 2.0f, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, chainTarget);
                        }
                        level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f), new Vector3f(1.0f), targetBodyPos.toVector3f(), 2.0f, 3, 0.0f), hitPos.x, hitPos.y, hitPos.z, 0.0, 0.0, 0.0);
                        TickScheduler.schedule(5, () -> EffectUtil.lineEffect(level, new SparkParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 3, 0.0f), targetBodyPos, hitPos, 3, false), level.isClientSide);
                    }
                }
                this.addCooldown(level, user, stack);
                if (level.isClientSide) {
                    Fulgenza.playShootAnimation(user);
                }
                this.addCooldown(level, user, stack);
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    @Override
    protected void applyEffectToLivingTarget(Level level, Player user, LivingEntity target) {
        super.applyEffectToLivingTarget(level, user, target);
    }

    @Override
    protected void playBeamSound(Level level, Player user) {
        level.playSound(user, user.getX(), user.getY(), user.getZ(), SoundInit.FULGENZA.get(), SoundSource.PLAYERS, 1.0f, 0.6f + user.getRandom().nextFloat() * 0.6f);
    }

    @Override
    protected void addVisualEffect(Level level, Player user, Vec3 start, Vec3 hitPos) {
        int i;
        EffectUtil.lineEffect(level, new SparkParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 3, 0.0f), start, hitPos, 2, false);
        for (i = 0; i < 3; ++i) {
            level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f((float)hitPos.x, (float)hitPos.y, (float)hitPos.z), 1.0f, 1, 0.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
        }
        level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.5f, 0.5f, 0.7f), new Vector3f(0.3f, 0.3f, 0.5f), hitPos.toVector3f(), 1.0f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.3f, 0.3f, 0.4f), new Vector3f(0.2f, 0.2f, 0.4f), hitPos.toVector3f(), 3.0f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
        for (i = 0; i < 5; ++i) {
            level.addParticle((ParticleOptions)new ZapParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f((float)(hitPos.x + ((double)user.getRandom().nextFloat() - 0.5)), (float)(hitPos.y + ((double)user.getRandom().nextFloat() - 0.5)), (float)(hitPos.z + ((double)user.getRandom().nextFloat() - 0.5))), 1.0f, 3, 0.0f), hitPos.x, hitPos.y, hitPos.z, ((double)user.getRandom().nextFloat() - 0.5) * 2.0, ((double)user.getRandom().nextFloat() - 0.5) * 2.0, ((double)user.getRandom().nextFloat() - 0.5) * 2.0);
        }
    }
}

