/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.magic.spell.tremor;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.magic.charge.ChargeData;
import net.stln.magitech.magic.cooldown.CooldownData;
import net.stln.magitech.magic.mana.ManaUtil;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.particle.particle_option.BeamParticleEffect;
import net.stln.magitech.particle.particle_option.WaveParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.EntityUtil;
import net.stln.magitech.util.SpellShape;
import org.joml.Vector3f;

public class Quaveris
extends Spell {
    public Quaveris() {
        this.baseDamage = 10.0f;
        this.baseMaxRange = 20.0;
    }

    protected static void playShootAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.setAnimation((IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("wand_blink"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }

    public static void breakBlockWithoutTool(Level level, BlockPos pos, Player player) {
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return;
        }
        FluidState fluid = state.getFluidState();
        if (state.getTags().anyMatch(Predicate.isEqual(BlockTags.INCORRECT_FOR_WOODEN_TOOL))) {
            return;
        }
        ItemStack fakeWoodTool = new ItemStack((ItemLike)Items.WOODEN_PICKAXE);
        state.getBlock().playerDestroy(level, player, pos, state, level.getBlockEntity(pos), fakeWoodTool);
        level.levelEvent(player, 2001, pos, Block.getId((BlockState)state));
        state.getBlock().onDestroyedByPlayer(state, level, pos, player, true, fluid);
    }

    @Override
    public Element getElement() {
        return Element.TREMOR;
    }

    @Override
    public SpellShape getSpellShape() {
        return SpellShape.DASH;
    }

    @Override
    public Map<ManaUtil.ManaType, Double> getBaseRequiredMana() {
        HashMap<ManaUtil.ManaType, Double> cost = new HashMap<ManaUtil.ManaType, Double>();
        cost.put(ManaUtil.ManaType.MANA, 65.0);
        cost.put(ManaUtil.ManaType.NOCTIS, 8.5);
        return cost;
    }

    @Override
    public int getCooldown(Level level, Player user, ItemStack stack) {
        return 100;
    }

    @Override
    public void use(Level level, Player user, InteractionHand hand, boolean isHost) {
        this.addCharge(user, 30, this.getElement());
        super.use(level, user, hand, isHost);
    }

    @Override
    public boolean isActiveUse(Level level, Player user, InteractionHand hand, boolean isHost) {
        return CooldownData.getCurrentCooldown(user, this) == null;
    }

    @Override
    public boolean canHoldUsing() {
        return true;
    }

    @Override
    public void finishUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, boolean isHost) {
        super.finishUsing(stack, level, livingEntity, timeCharged, isHost);
        if (livingEntity instanceof Player) {
            Player user = (Player)livingEntity;
            if (ChargeData.getCurrentCharge(user) == null && timeCharged > 1 && ManaUtil.useManaServerOnly(user, this.getRequiredMana(level, user, stack))) {
                Vec3 forward = Vec3.directionFromRotation((Vec2)user.getRotationVector());
                Vec3 hitPos = EntityUtil.raycast(user, this.getDamage(user, this.getRequiredMana(level, user, stack), (float)this.baseMaxRange, this.getElement())).subtract(forward.scale((double)(livingEntity.getBbWidth() / 2.0f) + 0.1));
                Vec3 start = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0).add(forward.scale(0.5));
                EffectUtil.lineEffect(level, new WaveParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), start, hitPos, 2, false);
                level.addParticle((ParticleOptions)new BeamParticleEffect(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f), hitPos.toVector3f(), 0.7f, 1, 1.0f), start.x, start.y, start.z, 0.0, 0.0, 0.0);
                for (int i = 0; i < 20; ++i) {
                    level.addParticle((ParticleOptions)new WaveParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), hitPos.x, hitPos.y, hitPos.z, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0, ((double)user.getRandom().nextFloat() - 0.5) / 3.0);
                }
                Vec3 back = Vec3.directionFromRotation((Vec2)user.getRotationVector()).scale(-1.0);
                Vec3 bodyPos = user.position().add(0.0, (double)user.getBbHeight() * 0.7, 0.0);
                Vec3 offset = bodyPos.add(back.scale(1.0));
                Vec3 center = user.getEyePosition().add(back);
                Vec3 center2 = center.add(back.scale(2.0));
                ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
                int i = 0;
                while ((double)i < hitPos.distanceTo(user.position())) {
                    nearbyEntities.addAll(EntityUtil.getEntitiesInBox(level, (Entity)user, user.position().lerp(hitPos, (double)i / hitPos.distanceTo(user.position())), new Vec3(3.0, 3.0, 3.0)));
                    ++i;
                }
                for (int j = 0; j < 10; ++j) {
                    level.addParticle((ParticleOptions)new WaveParticleEffect(new Vector3f(1.0f), new Vector3f(1.0f), 5.0f, 1, 0.3f), offset.x + ((double)user.getRandom().nextFloat() - 0.5) / 4.0, offset.y + ((double)user.getRandom().nextFloat() - 0.5) / 4.0, offset.z + ((double)user.getRandom().nextFloat() - 0.5) / 4.0, back.x * 0.75 + ((double)user.getRandom().nextFloat() - 0.5) / 2.0, back.y * 0.75 + ((double)user.getRandom().nextFloat() - 0.5) / 2.0, back.z * 0.75 + ((double)user.getRandom().nextFloat() - 0.5) / 2.0);
                }
                for (Entity entity : nearbyEntities) {
                    EffectUtil.entityEffect(level, new WaveParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), entity, 30);
                    if (!(entity instanceof LivingEntity) || !entity.isAlive()) continue;
                    this.applyDamage(this.baseDamage, this.getRequiredMana(level, user, stack), this.getElement(), stack, user, entity);
                }
                livingEntity.setPos(hitPos);
                for (i = -2; i < 2; ++i) {
                    for (int j = -2; j < 2; ++j) {
                        for (int k = -2; k < 2; ++k) {
                            Quaveris.breakBlockWithoutTool(level, user.blockPosition().offset(i, j, k), user);
                        }
                    }
                }
                this.addCooldown(level, user, stack);
                level.playSound(user, hitPos.x, hitPos.y, hitPos.z, SoundInit.QUAVERIS.get(), SoundSource.PLAYERS, 1.0f, 0.7f + user.getRandom().nextFloat() * 0.6f);
                livingEntity.fallDistance = 0.0f;
                if (level.isClientSide) {
                    Quaveris.playShootAnimation(user);
                }
            } else {
                ChargeData.removeCharge(user);
            }
        }
    }

    @Override
    protected void playAnimation(Player user) {
        ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)user)).get(Magitech.id("animation"));
        if (playerAnimationData != null) {
            user.yBodyRot = user.yHeadRot;
            playerAnimationData.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (Ease)Ease.OUTSINE), (IAnimation)new KeyframeAnimationPlayer((KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)Magitech.id("charge_wand"))).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration(true, true, true, true)));
        }
    }
}

