/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.network;

import java.util.Objects;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.network.SwapToolFromBeltPayload;
import net.stln.magitech.util.CuriosHelper;
import net.stln.magitech.util.ToolBeltHelper;

public class SwapToolFromBeltPayLoadHandler {
    public static void handleDataOnMainS2C(SwapToolFromBeltPayload payload, IPayloadContext context) {
        Player player = null;
        int select = payload.select();
        Level level = context.player().level();
        for (Player search : level.players()) {
            if (!Objects.equals(search.getUUID(), payload.uuid())) continue;
            player = search;
            break;
        }
        if (player == null) {
            return;
        }
        Player finalPlayer = player;
        CuriosHelper.getToolBeltStack(player).ifPresent(stack -> ToolBeltHelper.swapTool(finalPlayer, stack, select));
    }

    public static void handleDataOnMainC2S(SwapToolFromBeltPayload payload, IPayloadContext context) {
        Player player = context.player().level().getPlayerByUUID(payload.uuid());
        int select = payload.select();
        if (player == null) {
            return;
        }
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            if (player.getUUID() == serverPlayer.getUUID()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        Player finalPlayer = player;
        CuriosHelper.getToolBeltStack((LivingEntity)player).ifPresent(stack -> ToolBeltHelper.swapTool(finalPlayer, stack, select));
    }
}

