/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.network;

import java.util.Objects;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.network.TraitTickPayload;

public class TraitTickPayLoadHandler {
    public static void handleDataOnMainS2C(TraitTickPayload payload, IPayloadContext context) {
        Item item;
        Player player = null;
        Level level = context.player().level();
        for (Player search : level.players()) {
            if (!Objects.equals(search.getUUID(), payload.uuid())) continue;
            player = search;
            break;
        }
        Player player1 = player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getInventory().getItem(payload.slot());
        if (payload.isInventory() && (item = stack.getItem()) instanceof PartToolItem) {
            PartToolItem partToolItem = (PartToolItem)item;
            PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.inventoryTick(player1, player1.level(), stack, (int)integer, ((PartToolItem)stack.getItem()).getSumStats(player1, player1.level(), stack), false));
        } else {
            item = stack.getItem();
            if (item instanceof PartToolItem) {
                PartToolItem partToolItem = (PartToolItem)item;
                PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.tick(player1, player1.level(), stack, (int)integer, ((PartToolItem)stack.getItem()).getSumStats(player1, player1.level(), stack), false));
            }
        }
    }

    public static void handleDataOnMainC2S(TraitTickPayload payload, IPayloadContext context) {
        Item item;
        Player player = context.player().level().getPlayerByUUID(payload.uuid());
        if (player == null) {
            return;
        }
        ItemStack stack = player.getInventory().getItem(payload.slot());
        if (payload.isInventory() && (item = stack.getItem()) instanceof PartToolItem) {
            PartToolItem partToolItem = (PartToolItem)item;
            PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.inventoryTick(player, player.level(), stack, (int)integer, ((PartToolItem)stack.getItem()).getSumStats(player, player.level(), stack), false));
        } else {
            item = stack.getItem();
            if (item instanceof PartToolItem) {
                PartToolItem partToolItem = (PartToolItem)item;
                PartToolItem.getTraitLevel(PartToolItem.getTraits(stack)).forEach((trait, integer) -> trait.tick(player, player.level(), stack, (int)integer, ((PartToolItem)stack.getItem()).getSumStats(player, player.level(), stack), false));
            }
        }
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            if (player.getUUID() == serverPlayer.getUUID()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

