/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.stln.magitech.particle.GlowingParticle;
import net.stln.magitech.particle.particle_option.RuneParticleEffect;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RuneParticle
extends GlowingParticle {
    private final SpriteSet spriteProvider;
    private final Vector3f startColor;
    private final Vector3f endColor;

    public RuneParticle(ClientLevel clientWorld, double x, double y, double z, double vx, double vy, double vz, RuneParticleEffect parameters, SpriteSet spriteProvider) {
        super(clientWorld, x, y, z, vx, vy, vz);
        this.xd = vx + (double)((clientWorld.random.nextFloat() - 0.5f) / 30.0f);
        this.yd = vy + (double)((clientWorld.random.nextFloat() - 0.5f) / 30.0f);
        this.zd = vz + (double)((clientWorld.random.nextFloat() - 0.5f) / 30.0f);
        this.lifetime = 5 + clientWorld.random.nextInt(0, 15);
        this.alpha = 1.0f;
        this.scale = 1.0f * parameters.getScale();
        this.gravity = 0.0f;
        this.friction = 0.9f;
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
        this.startColor = parameters.getFromColor();
        this.endColor = parameters.getToColor();
        this.twinkle = parameters.getTwinkle();
        this.rotSpeed = parameters.getRotSpeed() + (clientWorld.random.nextFloat() - 0.5f) / 10.0f;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        this.updateColor(tickDelta);
        if (this.twinkle > 1) {
            float multiplier = Math.max((float)this.age % (float)this.twinkle / (float)(this.twinkle - 1), 0.1f);
            this.rCol *= multiplier;
            this.gCol *= multiplier;
            this.bCol *= multiplier;
        }
        super.render(vertexConsumer, camera, tickDelta);
    }

    private void updateColor(float tickDelta) {
        float f = ((float)this.age + tickDelta) / ((float)this.lifetime + 1.0f);
        Vector3f vector3f = new Vector3f((Vector3fc)this.startColor).lerp((Vector3fc)this.endColor, f);
        this.rCol = vector3f.x();
        this.gCol = vector3f.y();
        this.bCol = vector3f.z();
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(this.xd, this.yd, this.zd);
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
        }
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
        this.rotate();
        this.setSpriteFromAge(this.spriteProvider);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Provider
    implements ParticleProvider<RuneParticleEffect> {
        private final SpriteSet spriteProvider;

        public Provider(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Nullable
        public Particle createParticle(RuneParticleEffect parameters, ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
            return new RuneParticle(world, x, y, z, xd, yd, zd, parameters, this.spriteProvider);
        }
    }
}

