/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.MaterialComponent;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import net.stln.magitech.util.ClientHelper;
import org.jetbrains.annotations.NotNull;

public record PartCuttingRecipe(String group, int inputCount, ItemStack result) implements Recipe<SingleRecipeInput>
{
    public static final MapCodec<PartCuttingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(PartCuttingRecipe::group), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("input_count", (Object)1).forGetter(PartCuttingRecipe::inputCount), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(PartCuttingRecipe::result)).apply((Applicative)instance, PartCuttingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PartCuttingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PartCuttingRecipe::group, (StreamCodec)ByteBufCodecs.VAR_INT, PartCuttingRecipe::inputCount, (StreamCodec)ItemStack.STREAM_CODEC, PartCuttingRecipe::result, PartCuttingRecipe::new);

    public boolean matches(@NotNull SingleRecipeInput input, @NotNull Level level) {
        if (level != null) {
            return input.item().getCount() >= this.inputCount && !level.getRecipeManager().getRecipesFor(RecipeInit.TOOL_MATERIAL_TYPE.get(), (RecipeInput)input, level).isEmpty();
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ItemStack itemStack = this.result.copy();
        Level level = Optional.ofNullable(ServerLifecycleHooks.getCurrentServer()).map(MinecraftServer::overworld).map(serverLevel -> serverLevel).orElseGet(ClientHelper::getLevel);
        if (level != null) {
            level.getRecipeManager().getRecipesFor(RecipeInit.TOOL_MATERIAL_TYPE.get(), (RecipeInput)input, level).stream().findFirst().map(RecipeHolder::value).map(ToolMaterialRecipe::getToolMaterial).ifPresent(toolMaterial -> itemStack.set(ComponentInit.MATERIAL_COMPONENT, (Object)new MaterialComponent((ToolMaterial)toolMaterial)));
        }
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result().copy();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return BlockInit.ENGINEERING_WORKBENCH.toStack();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeInit.PART_CUTTING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return RecipeInit.PART_CUTTING_TYPE.get();
    }
}

