/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.input.SpellRecipeInput;
import org.jetbrains.annotations.NotNull;

public record SpellConversionRecipe(String group, Ingredient ingredient, Spell spell, ItemStack result) implements Recipe<SpellRecipeInput>
{
    public static final MapCodec<SpellConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SpellConversionRecipe::group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(SpellConversionRecipe::ingredient), (App)Spell.CODEC.fieldOf("spell").forGetter(SpellConversionRecipe::spell), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(SpellConversionRecipe::result)).apply((Applicative)instance, SpellConversionRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellConversionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SpellConversionRecipe::group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SpellConversionRecipe::ingredient, Spell.STREAM_CODEC, SpellConversionRecipe::spell, (StreamCodec)ItemStack.STREAM_CODEC, SpellConversionRecipe::result, SpellConversionRecipe::new);

    public boolean matches(@NotNull SpellRecipeInput input, @NotNull Level level) {
        return this.ingredient.test(input.item()) && Objects.equals(this.spell, input.spell());
    }

    @NotNull
    public ItemStack assemble(@NotNull SpellRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result().copy();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return ItemInit.FLUORITE.toStack();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeInit.SPELL_CONVERSION_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return RecipeInit.SPELL_CONVERSION_TYPE.get();
    }
}

