/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentHolder;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.MaterialComponent;
import net.stln.magitech.item.component.PartMaterialComponent;
import net.stln.magitech.item.component.SpellComponent;
import net.stln.magitech.item.component.ThreadPageComponent;
import net.stln.magitech.item.component.ToolBeltComponent;
import net.stln.magitech.item.component.UpgradeComponent;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.item.tool.upgrade.UpgradeInstance;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.magic.spell.SpellLike;
import org.jetbrains.annotations.NotNull;

public class ComponentHelper {
    @NotNull
    public static List<ToolMaterial> getPartMaterials(@NotNull DataComponentHolder holder) {
        return ((PartMaterialComponent)holder.getOrDefault(ComponentInit.PART_MATERIAL_COMPONENT, (Object)PartMaterialComponent.EMPTY)).materials();
    }

    @NotNull
    public static Optional<ToolMaterial> getMaterial(@NotNull DataComponentHolder holder) {
        return Optional.ofNullable((MaterialComponent)holder.get(ComponentInit.MATERIAL_COMPONENT)).map(MaterialComponent::material);
    }

    @NotNull
    public static SpellComponent getSpells(@NotNull DataComponentHolder holder) {
        return (SpellComponent)holder.getOrDefault(ComponentInit.SPELL_COMPONENT, (Object)SpellComponent.EMPTY);
    }

    @NotNull
    public static ToolBeltComponent getToolsInBelt(@NotNull DataComponentHolder holder) {
        return (ToolBeltComponent)holder.getOrDefault(ComponentInit.TOOLBELT_COMPONENT, (Object)ToolBeltComponent.EMPTY);
    }

    @NotNull
    public static Optional<Spell> getThreadPageSpell(@NotNull DataComponentHolder holder) {
        return Optional.ofNullable((ThreadPageComponent)holder.get(ComponentInit.THREAD_PAGE_COMPONENT)).map(ThreadPageComponent::spell);
    }

    public static int getTier(@NotNull DataComponentHolder holder) {
        return (Integer)holder.getOrDefault(ComponentInit.TIER_COMPONENT, (Object)0);
    }

    @NotNull
    public static List<UpgradeInstance> getUpgrades(@NotNull DataComponentHolder holder) {
        return ((UpgradeComponent)holder.getOrDefault(ComponentInit.UPGRADE_COMPONENT, (Object)UpgradeComponent.EMPTY)).upgrades();
    }

    public static int getUpgradePoint(@NotNull DataComponentHolder holder) {
        return (Integer)holder.getOrDefault(ComponentInit.UPGRADE_POINT_COMPONENT, (Object)0);
    }

    public static boolean isBroken(@NotNull DataComponentHolder holder) {
        return (Boolean)holder.getOrDefault(ComponentInit.BROKEN_COMPONENT, (Object)false);
    }

    public static SimpleFluidContent getFluidContent(@NotNull DataComponentHolder holder) {
        return (SimpleFluidContent)holder.getOrDefault(ComponentInit.FLUID_CONTENT_COMPONENT, (Object)SimpleFluidContent.EMPTY);
    }

    public static void setThreadPage(@NotNull MutableDataComponentHolder holder, @NotNull SpellLike spell) {
        holder.set(ComponentInit.THREAD_PAGE_COMPONENT, (Object)new ThreadPageComponent(spell));
    }

    public static void updateSpells(@NotNull MutableDataComponentHolder holder, @NotNull UnaryOperator<SpellComponent> operator) {
        holder.update(ComponentInit.SPELL_COMPONENT, (Object)SpellComponent.EMPTY, operator);
    }

    public static void updateToolBelt(@NotNull MutableDataComponentHolder holder, @NotNull UnaryOperator<ToolBeltComponent> operator) {
        holder.update(ComponentInit.TOOLBELT_COMPONENT, (Object)ToolBeltComponent.EMPTY, operator);
    }

    public static void updateUpgradePoint(@NotNull MutableDataComponentHolder holder, UnaryOperator<Integer> operator) {
        holder.update(ComponentInit.UPGRADE_POINT_COMPONENT, (Object)0, operator);
    }
}

