/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.stln.magitech.element.Element;
import net.stln.magitech.item.tool.ToolStats;
import net.stln.magitech.item.tool.ToolType;
import net.stln.magitech.item.tool.register.ToolMaterialRegister;
import net.stln.magitech.item.tool.upgrade.UpgradeInstance;
import net.stln.magitech.util.MathUtil;

public class RenderHelper {
    public static RenderType additiveNoCull(ResourceLocation texture) {
        return RenderType.create((String)"additive_nocull", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENERGY_SWIRL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(RenderStateShard.ADDITIVE_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
    }

    public static RenderType additiveCull(ResourceLocation texture) {
        return RenderType.create((String)"additive_nocull", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENERGY_SWIRL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(RenderStateShard.ADDITIVE_TRANSPARENCY).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
    }

    public static void renderFramedText(GuiGraphics guiGraphics, Font font, String text, int x, int y, Element element) {
        RenderHelper.renderFramedText(guiGraphics, font, text, x, y, element.getSpellColor(), element.getSpellDark());
    }

    public static void renderFramedText(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color, int frameColor) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                if (i == 0 && j == 0) continue;
                guiGraphics.drawString(font, text, (float)x + (float)i / 2.0f, (float)y + (float)j / 2.0f, frameColor, false);
            }
        }
        guiGraphics.drawString(font, text, x, y, color, false);
    }

    public static Component getGradationGauge(int min, int max, int current, int length, int startColor, int endColor) {
        double ratio = (double)(current - min) / (double)(max - min);
        int litLength = (int)(ratio * (double)length);
        MutableComponent gauge = Component.empty();
        for (int i = 0; i < length; ++i) {
            if (i < litLength) {
                double colorRatio = (double)i / (double)(length - 1);
                int r = (int)((double)(startColor >> 16 & 0xFF) * (1.0 - colorRatio) + (double)(endColor >> 16 & 0xFF) * colorRatio);
                int g = (int)((double)(startColor >> 8 & 0xFF) * (1.0 - colorRatio) + (double)(endColor >> 8 & 0xFF) * colorRatio);
                int b = (int)((double)(startColor & 0xFF) * (1.0 - colorRatio) + (double)(endColor & 0xFF) * colorRatio);
                int color = r << 16 | g << 8 | b;
                gauge.append((Component)Component.literal((String)"|").withStyle(style -> style.withColor(color)));
                continue;
            }
            gauge.append((Component)Component.literal((String)"|").withStyle(style -> style.withColor(0x404040)));
        }
        return gauge;
    }

    public static List<Component> getUpgradeTooltips(List<UpgradeInstance> instances, ToolType type, boolean isSpellCaster) {
        List<ToolStats> statsList = instances.stream().map(i -> ToolStats.mulWithoutElementCode(i.upgrade().getUpgradeStats(i.level()), ToolMaterialRegister.getBaseStats(type))).toList();
        ToolStats finalStats = ToolStats.addWithoutElementCode(statsList);
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        if (finalStats.getStats().get(ToolStats.ATK_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)(isSpellCaster ? "attribute.magitech.spell_power" : "attribute.magitech.attack_damage")).withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.ATK_STAT).floatValue(), 2))).withColor(0xFF4040)));
        }
        if (finalStats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)(isSpellCaster ? "attribute.magitech.elemental_spell_power" : "attribute.magitech.elemental_damage")).withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.ELM_ATK_STAT).floatValue(), 2))).withColor(0x80FF80)));
        }
        if (finalStats.getStats().get(ToolStats.SPD_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)(isSpellCaster ? "attribute.magitech.casting_speed" : "attribute.magitech.attack_speed")).withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.SPD_STAT).floatValue(), 2))).withColor(4259776)));
        }
        if (finalStats.getStats().get(ToolStats.MIN_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)(isSpellCaster ? "attribute.magitech.cooldown_speed" : "attribute.magitech.mining_speed")).withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.MIN_STAT).floatValue(), 2))).withColor(4227264)));
        }
        if (finalStats.getStats().get(ToolStats.DEF_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.defense").withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.DEF_STAT).floatValue(), 2))).withColor(0xA0C0C0)));
        }
        if (finalStats.getStats().get(ToolStats.RNG_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)(isSpellCaster ? "attribute.magitech.projectile_speed" : "attribute.magitech.attack_range")).withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.RNG_STAT).floatValue(), 2))).withColor(8438015)));
        }
        if (finalStats.getStats().get(ToolStats.SWP_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)(isSpellCaster ? "attribute.magitech.mana_efficiency" : "attribute.magitech.sweep_range")).withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + MathUtil.round(finalStats.getStats().get(ToolStats.SWP_STAT).floatValue(), 2))).withColor(0xFFFF80)));
        }
        if (finalStats.getStats().get(ToolStats.DUR_STAT).floatValue() > 0.0f) {
            tooltipComponents.add((Component)Component.translatable((String)"attribute.magitech.durability").withColor(0xA0A0A0).append((Component)Component.literal((String)(" +" + Math.round(finalStats.getStats().get(ToolStats.DUR_STAT).floatValue()))).withColor(0xFFFFFF)));
        }
        return tooltipComponents;
    }
}

