/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.TickTask;
import org.jetbrains.annotations.Nullable;

public class TickScheduler {
    private static final List<TickTask> scheduledTasksServer = new ArrayList<TickTask>();
    private static final List<TickTask> scheduledTasksClient = new ArrayList<TickTask>();

    public static void schedule(int delayTicks, Runnable task, @Nullable Boolean isClient) {
        if (isClient == null) {
            scheduledTasksServer.add(new TickTask(delayTicks, task));
            scheduledTasksClient.add(new TickTask(delayTicks, task));
        } else if (isClient.booleanValue()) {
            scheduledTasksClient.add(new TickTask(delayTicks, task));
        } else {
            scheduledTasksServer.add(new TickTask(delayTicks, task));
        }
    }

    public static void tick(boolean isClient) {
        TickScheduler.tick(!isClient ? scheduledTasksServer : scheduledTasksClient);
    }

    private static void tick(List<TickTask> tasks) {
        Iterator<TickTask> iterator = tasks.iterator();
        ArrayList<TickTask> nextTask = new ArrayList<TickTask>();
        while (iterator.hasNext()) {
            TickTask task = iterator.next();
            int newDelay = task.getTick() - 1;
            if (newDelay <= 0) {
                task.run();
            } else {
                nextTask.add(new TickTask(newDelay, (Runnable)task));
            }
            iterator.remove();
        }
        tasks.addAll(nextTask);
    }
}

