/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.stln.magitech.item.ItemTagKeys;
import net.stln.magitech.item.tool.material.ToolMaterial;
import org.jetbrains.annotations.NotNull;

public class ToolMaterialUtil {
    @NotNull
    public static List<ToolMaterial> getMaterialCombinationAt(@NotNull List<ToolMaterial> materials, int partCount, long index) {
        ArrayList<ToolMaterial> result = new ArrayList<ToolMaterial>();
        int base = materials.size();
        for (int i = 0; i < partCount; ++i) {
            int materialIndex = (int)(index % (long)base);
            result.add(materials.get(materialIndex));
            index /= (long)base;
        }
        return result;
    }

    public static boolean isCorrectMaterialForUpgrade(int tier, int point, @NotNull Item item) {
        return item.getDefaultInstance().is(ToolMaterialUtil.getUpgradeMaterialTag(tier, point));
    }

    public static TagKey<Item> getUpgradeMaterialTag(int tier, int point) {
        return switch (tier - point) {
            case 0, 1, 2, 3, 4 -> ItemTagKeys.UPGRADE_MATERIAL_0;
            case 5, 6, 7, 8, 9 -> ItemTagKeys.UPGRADE_MATERIAL_5;
            case 10, 11, 12, 13, 14 -> ItemTagKeys.UPGRADE_MATERIAL_10;
            case 15, 16, 17, 18, 19 -> ItemTagKeys.UPGRADE_MATERIAL_15;
            default -> ItemTagKeys.UPGRADE_MATERIAL_20;
        };
    }
}

