/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    public static VoxelShape rotateShape(VoxelShape shape, Direction from, Direction to) {
        if (from == to) {
            return shape;
        }
        VoxelShape toNorth = VoxelShapeUtil.rotateToNorth(shape, from);
        return VoxelShapeUtil.rotateFromNorth(toNorth, to);
    }

    private static VoxelShape rotateToNorth(VoxelShape shape, Direction from) {
        return VoxelShapeUtil.rotateShapeInternal(shape, VoxelShapeUtil.getInverseRotation(from));
    }

    private static VoxelShape rotateFromNorth(VoxelShape shape, Direction to) {
        return VoxelShapeUtil.rotateShapeInternal(shape, VoxelShapeUtil.getModelRotation(to));
    }

    private static VoxelShape rotateShapeInternal(VoxelShape shape, RotationAngles rotation) {
        ArrayList<AABB> rotatedBoxes = new ArrayList<AABB>();
        for (AABB box : shape.toAabbs()) {
            List<Vec3> corners = VoxelShapeUtil.getCorners(box);
            ArrayList<Vec3> transformed = new ArrayList<Vec3>();
            for (Vec3 point : corners) {
                transformed.add(VoxelShapeUtil.applyRotation(point, rotation));
            }
            rotatedBoxes.add(VoxelShapeUtil.buildAABB(transformed));
        }
        return rotatedBoxes.stream().map(b -> Shapes.box((double)b.minX, (double)b.minY, (double)b.minZ, (double)b.maxX, (double)b.maxY, (double)b.maxZ)).reduce(Shapes.empty(), Shapes::or);
    }

    private static Vec3 applyRotation(Vec3 point, RotationAngles rot) {
        int i;
        double x = point.x - 0.5;
        double y = point.y - 0.5;
        double z = point.z - 0.5;
        for (i = 0; i < rot.x / 90; ++i) {
            double ty = y;
            y = z;
            z = -ty;
        }
        for (i = 0; i < rot.y / 90; ++i) {
            double tx = x;
            x = -z;
            z = tx;
        }
        return new Vec3(x + 0.5, y + 0.5, z + 0.5);
    }

    private static List<Vec3> getCorners(AABB box) {
        return List.of(new Vec3(box.minX, box.minY, box.minZ), new Vec3(box.minX, box.minY, box.maxZ), new Vec3(box.minX, box.maxY, box.minZ), new Vec3(box.minX, box.maxY, box.maxZ), new Vec3(box.maxX, box.minY, box.minZ), new Vec3(box.maxX, box.minY, box.maxZ), new Vec3(box.maxX, box.maxY, box.minZ), new Vec3(box.maxX, box.maxY, box.maxZ));
    }

    private static AABB buildAABB(List<Vec3> points) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Vec3 p : points) {
            minX = Math.min(minX, p.x);
            minY = Math.min(minY, p.y);
            minZ = Math.min(minZ, p.z);
            maxX = Math.max(maxX, p.x);
            maxY = Math.max(maxY, p.y);
            maxZ = Math.max(maxZ, p.z);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static RotationAngles getModelRotation(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new RotationAngles(180, 0);
            case Direction.UP -> new RotationAngles(0, 0);
            case Direction.NORTH -> new RotationAngles(90, 0);
            case Direction.SOUTH -> new RotationAngles(90, 180);
            case Direction.WEST -> new RotationAngles(90, 270);
            case Direction.EAST -> new RotationAngles(90, 90);
        };
    }

    private static RotationAngles getInverseRotation(Direction direction) {
        RotationAngles rot = VoxelShapeUtil.getModelRotation(direction);
        return new RotationAngles((360 - rot.x) % 360, (360 - rot.y) % 360);
    }

    private record RotationAngles(int x, int y) {
    }
}

