/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.worldgen;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.stln.magitech.Magitech;
import net.stln.magitech.biome.BiomeInit;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.FluoriteCrystalClusterBlock;
import net.stln.magitech.block.RedstoneCrystalClusterBlock;
import net.stln.magitech.worldgen.OreSurfaceFeature;
import net.stln.magitech.worldgen.terrain.ScorchedGeyserFeature;
import net.stln.magitech.worldgen.terrain.ScorchedLavaLakeFeature;
import net.stln.magitech.worldgen.tree.RandomBranchingTrunkPlacer;
import net.stln.magitech.worldgen.tree.RandomShortBranchingTrunkPlacer;

public class WorldGenInit {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"magitech");
    public static final Supplier<Feature<NoneFeatureConfiguration>> REDSTONE_CRYSTAL_SURFACE_FEATURE = FEATURES.register("redstone_crystal_surface", () -> new OreSurfaceFeature(((RedstoneCrystalClusterBlock)((Object)((Object)BlockInit.REDSTONE_CRYSTAL_CLUSTER.get()))).defaultBlockState(), List.of(Blocks.REDSTONE_ORE, Blocks.DEEPSLATE_REDSTONE_ORE), 0.25));
    public static final ResourceKey<ConfiguredFeature<?, ?>> REDSTONE_CRYSTAL_SURFACE_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("redstone_crystal_surface"));
    public static final ResourceKey<PlacedFeature> REDSTONE_CRYSTAL_SURFACE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("redstone_crystal_surface"));
    public static final ResourceKey<BiomeModifier> REDSTONE_CRYSTAL_SURFACE_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("redstone_crystal_surface"));
    public static final Supplier<Feature<NoneFeatureConfiguration>> FLUORITE_CRYSTAL_SURFACE_FEATURE = FEATURES.register("fluorite_crystal_surface", () -> new OreSurfaceFeature(((FluoriteCrystalClusterBlock)((Object)((Object)BlockInit.FLUORITE_CRYSTAL_CLUSTER.get()))).defaultBlockState(), List.of((Block)BlockInit.FLUORITE_ORE.get(), (Block)BlockInit.DEEPSLATE_FLUORITE_ORE.get()), 0.25));
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLUORITE_CRYSTAL_SURFACE_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("fluorite_crystal_surface"));
    public static final ResourceKey<PlacedFeature> FLUORITE_CRYSTAL_SURFACE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("fluorite_crystal_surface"));
    public static final ResourceKey<BiomeModifier> FLUORITE_CRYSTAL_SURFACE_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("fluorite_crystal_surface"));
    public static final Supplier<Feature<OreConfiguration>> FLUORITE_ORE_FEATURE = FEATURES.register("fluorite_ore", () -> new OreFeature(OreConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLUORITE_ORE_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("fluorite_ore"));
    public static final ResourceKey<PlacedFeature> FLUORITE_ORE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("fluorite_ore"));
    public static final ResourceKey<BiomeModifier> FLUORITE_ORE_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("fluorite_ore"));
    public static final Supplier<Feature<OreConfiguration>> TOURMALINE_ORE_FEATURE = FEATURES.register("tourmaline_ore", () -> new OreFeature(OreConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOURMALINE_ORE_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("tourmaline_ore"));
    public static final ResourceKey<PlacedFeature> TOURMALINE_ORE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("tourmaline_ore"));
    public static final ResourceKey<BiomeModifier> TOURMALINE_ORE_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("tourmaline_ore"));
    public static final Supplier<Feature<OreConfiguration>> ZINC_ORE_FEATURE = FEATURES.register("zinc_ore", () -> new OreFeature(OreConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZINC_ORE_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("zinc_ore"));
    public static final ResourceKey<PlacedFeature> ZINC_ORE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("zinc_ore"));
    public static final ResourceKey<BiomeModifier> ZINC_ORE_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("zinc_ore"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> CELIFERN_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("celifern"));
    public static final ResourceKey<PlacedFeature> CELIFERN_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("celifern"));
    public static final ResourceKey<BiomeModifier> CELIFERN_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("celifern"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHARCOAL_BIRCH_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("charcoal_birch"));
    public static final ResourceKey<PlacedFeature> CHARCOAL_BIRCH_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("charcoal_birch"));
    public static final ResourceKey<BiomeModifier> CHARCOAL_BIRCH_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("charcoal_birch"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> MANA_BERRY_BUSH_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("mana_berry_bush"));
    public static final ResourceKey<PlacedFeature> MANA_BERRY_BUSH_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("mana_berry_bush"));
    public static final ResourceKey<BiomeModifier> MANA_BERRY_BUSH_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("mana_berry_bush"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> MISTALIA_PETALS_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("mistalia_petals"));
    public static final ResourceKey<PlacedFeature> MISTALIA_PETALS_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("mistalia_petals"));
    public static final ResourceKey<BiomeModifier> MISTALIA_PETALS_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("mistalia_petals"));
    public static final Supplier<Feature<NoneFeatureConfiguration>> SCORCHED_GEYSER_FEATURE = FEATURES.register("scorched_geyser", () -> new ScorchedGeyserFeature());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SCORCHED_GEYSER_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("scorched_geyser"));
    public static final ResourceKey<PlacedFeature> SCORCHED_GEYSER_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("scorched_geyser"));
    public static final ResourceKey<BiomeModifier> SCORCHED_GEYSER_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("scorched_geyser"));
    public static final Supplier<Feature<NoneFeatureConfiguration>> SCORCHED_LAVA_LAKE_FEATURE = FEATURES.register("scorched_lava_lake", () -> new ScorchedLavaLakeFeature());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SCORCHED_LAVA_LAKE_CONFIGURED_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Magitech.id("scorched_lava_lake"));
    public static final ResourceKey<PlacedFeature> SCORCHED_LAVA_LAKE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Magitech.id("scorched_lava_lake"));
    public static final ResourceKey<BiomeModifier> SCORCHED_LAVA_LAKE_BIOME_MODIFIER_KEY = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Magitech.id("scorched_lava_lake"));

    public static void Configured(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest ruletestStone = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest ruletestDeepslate = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        context.register(REDSTONE_CRYSTAL_SURFACE_CONFIGURED_KEY, (Object)new ConfiguredFeature(REDSTONE_CRYSTAL_SURFACE_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        context.register(FLUORITE_CRYSTAL_SURFACE_CONFIGURED_KEY, (Object)new ConfiguredFeature(FLUORITE_CRYSTAL_SURFACE_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        List<OreConfiguration.TargetBlockState> fluoriteList = List.of(OreConfiguration.target((RuleTest)ruletestStone, (BlockState)((DropExperienceBlock)BlockInit.FLUORITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)ruletestDeepslate, (BlockState)((DropExperienceBlock)BlockInit.DEEPSLATE_FLUORITE_ORE.get()).defaultBlockState()));
        context.register(FLUORITE_ORE_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(fluoriteList, 8)));
        List<OreConfiguration.TargetBlockState> tourmalineList = List.of(OreConfiguration.target((RuleTest)ruletestStone, (BlockState)((DropExperienceBlock)BlockInit.TOURMALINE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)ruletestDeepslate, (BlockState)((DropExperienceBlock)BlockInit.DEEPSLATE_TOURMALINE_ORE.get()).defaultBlockState()));
        context.register(TOURMALINE_ORE_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(tourmalineList, 8)));
        List<OreConfiguration.TargetBlockState> zincList = List.of(OreConfiguration.target((RuleTest)ruletestStone, (BlockState)((DropExperienceBlock)BlockInit.ZINC_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)ruletestDeepslate, (BlockState)((DropExperienceBlock)BlockInit.DEEPSLATE_ZINC_ORE.get()).defaultBlockState()));
        context.register(ZINC_ORE_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(zincList, 8)));
        HolderGetter holdergetter = context.lookup(Registries.BLOCK);
        context.register(CELIFERN_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.CELIFERN_LOG.get())), (TrunkPlacer)new RandomBranchingTrunkPlacer(8, 1, 3), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.CELIFERN_LEAVES.get())), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)2), 70), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build()));
        context.register(CHARCOAL_BIRCH_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.CHARCOAL_BIRCH_LOG.get())), (TrunkPlacer)new RandomShortBranchingTrunkPlacer(8, 1, 7), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.CHARCOAL_BIRCH_LEAVES.get())), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)2), 50), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build()));
        context.register(MANA_BERRY_BUSH_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockInit.MANA_BERRY_BUSH.get()).defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK))));
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)((Block)BlockInit.MISTALIA_PETALS.get()).defaultBlockState().setValue((Property)PinkPetalsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)PinkPetalsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        context.register(MISTALIA_PETALS_CONFIGURED_KEY, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder))))));
        context.register(SCORCHED_GEYSER_CONFIGURED_KEY, (Object)new ConfiguredFeature(SCORCHED_GEYSER_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
        context.register(SCORCHED_LAVA_LAKE_CONFIGURED_KEY, (Object)new ConfiguredFeature(SCORCHED_LAVA_LAKE_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
    }

    public static void bootstrapPlaced(BootstrapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(REDSTONE_CRYSTAL_SURFACE_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(REDSTONE_CRYSTAL_SURFACE_CONFIGURED_KEY), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top()))));
        context.register(FLUORITE_CRYSTAL_SURFACE_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(FLUORITE_CRYSTAL_SURFACE_CONFIGURED_KEY), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top()))));
        context.register(FLUORITE_ORE_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(FLUORITE_ORE_CONFIGURED_KEY), List.of(CountPlacement.of((int)12), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)))));
        context.register(TOURMALINE_ORE_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(TOURMALINE_ORE_CONFIGURED_KEY), List.of(CountPlacement.of((int)8), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)))));
        context.register(ZINC_ORE_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(ZINC_ORE_CONFIGURED_KEY), List.of(CountPlacement.of((int)8), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)))));
        context.register(CELIFERN_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(CELIFERN_CONFIGURED_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)3, (float)0.5f, (int)7), (Block)((Block)BlockInit.CELIFERN_SAPLING.get()))));
        context.register(CHARCOAL_BIRCH_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(CHARCOAL_BIRCH_CONFIGURED_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.2f, (int)3), (Block)((Block)BlockInit.CHARCOAL_BIRCH_SAPLING.get()))));
        context.register(MANA_BERRY_BUSH_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(MANA_BERRY_BUSH_CONFIGURED_KEY), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
        context.register(MISTALIA_PETALS_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(MISTALIA_PETALS_CONFIGURED_KEY), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
        context.register(SCORCHED_GEYSER_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(SCORCHED_GEYSER_CONFIGURED_KEY), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
        context.register(SCORCHED_LAVA_LAKE_PLACED_KEY, (Object)new PlacedFeature((Holder)configured.getOrThrow(SCORCHED_LAVA_LAKE_CONFIGURED_KEY), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
    }

    public static void bootstrapBiomeModifier(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        context.register(REDSTONE_CRYSTAL_SURFACE_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(REDSTONE_CRYSTAL_SURFACE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(FLUORITE_CRYSTAL_SURFACE_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(FLUORITE_CRYSTAL_SURFACE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.register(FLUORITE_ORE_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(FLUORITE_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(TOURMALINE_ORE_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(TOURMALINE_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ZINC_ORE_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ZINC_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(CELIFERN_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeInit.HAS_CELIFERN_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(CELIFERN_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(CHARCOAL_BIRCH_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeInit.HAS_CHARCOAL_BIRCH_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(CHARCOAL_BIRCH_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(MANA_BERRY_BUSH_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeInit.HAS_MANA_BERRY_BUSH), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(MANA_BERRY_BUSH_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(MISTALIA_PETALS_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeInit.HAS_MISTALIA_PETALS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(MISTALIA_PETALS_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(SCORCHED_GEYSER_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeInit.IS_SCORCHED), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SCORCHED_GEYSER_PLACED_KEY)}), GenerationStep.Decoration.SURFACE_STRUCTURES));
        context.register(SCORCHED_LAVA_LAKE_BIOME_MODIFIER_KEY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeInit.IS_SCORCHED), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SCORCHED_LAVA_LAKE_PLACED_KEY)}), GenerationStep.Decoration.SURFACE_STRUCTURES));
    }

    public static void registerFeatures(IEventBus eventBus) {
        Magitech.LOGGER.info("Registering Features formagitech");
        FEATURES.register(eventBus);
    }
}

