/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.worldgen.terrain;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.CrystalClusterBlock;

public class ScorchedGeyserFeature
extends Feature<NoneFeatureConfiguration> {
    public ScorchedGeyserFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockPos blockpos = ctx.origin();
        RandomSource random = ctx.random();
        WorldGenLevel level = ctx.level();
        int height = random.nextInt(30);
        this.addHill(level, blockpos, random, height);
        int count = 2;
        while (height / count > 3) {
            blockpos = blockpos.offset(random.nextInt(-10, 10), 0, random.nextInt(-10, 10));
            this.addHill(level, blockpos, random, height / count);
            ++count;
        }
        return true;
    }

    private void addHill(WorldGenLevel level, BlockPos blockpos, RandomSource random, int height) {
        int l;
        float f;
        int k;
        while (level.isEmptyBlock(blockpos) && blockpos.getY() > level.getMinBuildHeight() + 2) {
            blockpos = blockpos.below();
        }
        if (!level.getBlockState(blockpos).isCollisionShapeFullBlock((BlockGetter)level, blockpos)) {
            return;
        }
        blockpos = blockpos.above(random.nextInt(4));
        int j = height / 4 + random.nextInt(2);
        float v = 1.0f + random.nextFloat() * (float)(30 - height) / 30.0f;
        float scaleX = 0.6f + random.nextFloat() * 0.8f;
        float scaleZ = 0.6f + random.nextFloat() * 0.8f;
        int offsetX = random.nextInt(3) - 1;
        int offsetZ = random.nextInt(3) - 1;
        float offsetMul = random.nextFloat();
        double angle = Math.toRadians(random.nextInt(360));
        double hillRot = Math.toRadians(random.nextInt(360));
        for (k = 0; k < height; ++k) {
            f = (v - (float)k / (float)height) * (float)j;
            l = Mth.ceil((float)f);
            for (int dx = -l; dx <= l; ++dx) {
                for (int dz = -l; dz <= l; ++dz) {
                    float f2;
                    float f1 = Mth.abs((float)((float)(Math.cos(hillRot) * (double)dx - Math.sin(hillRot) * (double)dz))) - 0.25f;
                    float dist = f1 * f1 / (scaleX * scaleX) + (f2 = Mth.abs((float)((float)(Math.sin(hillRot) * (double)dx + Math.cos(hillRot) * (double)dz))) - 0.25f) * f2 / (scaleZ * scaleZ);
                    if (!(dist <= f * f)) continue;
                    BlockPos target = blockpos.offset((int)((float)dx + (float)offsetX * f * offsetMul), k, (int)((float)dz + (float)offsetZ * f * offsetMul));
                    BlockState below = level.getBlockState(target.below());
                    if (below.is((Block)BlockInit.SCORCHED_GRASS_SOIL.get())) {
                        this.setBlock((LevelWriter)level, target.below(), ((Block)BlockInit.SCORCHED_SOIL.get()).defaultBlockState());
                    }
                    this.setBlock((LevelWriter)level, target, ((Block)BlockInit.SCORCHED_GRASS_SOIL.get()).defaultBlockState());
                }
            }
        }
        for (k = 0; k < height; ++k) {
            f = (v - (float)k / (float)height) * (float)j;
            l = Mth.ceil((float)f);
            if (l <= 2 || k % 2 != 1) continue;
            BlockPos pos = blockpos.offset((int)((float)offsetX * f * offsetMul), k, (int)((float)offsetZ * f * offsetMul)).offset((int)(Math.cos(angle) * (double)f * (double)Mth.randomBetween((RandomSource)random, (float)0.8f, (float)1.3f)), 0, (int)(Math.sin(angle) * (double)f * (double)Mth.randomBetween((RandomSource)random, (float)0.8f, (float)1.3f)));
            this.addPool(level, pos, random, l * 2 / 3);
            angle += Math.toRadians(random.nextInt(60, 120));
        }
        int k1 = Mth.ceil((float)(v * (float)j));
        if (k1 < 0) {
            k1 = 0;
        }
        for (int dx = -k1; dx <= k1; ++dx) {
            for (int dz = -k1; dz <= k1; ++dz) {
                BlockState state;
                BlockPos blockpos1 = blockpos.offset((int)((float)dx + (float)(offsetX * k1) * offsetMul), -1, (int)((float)dz + (float)(offsetZ * k1) * offsetMul));
                int depthCounter = 10;
                while (blockpos1.getY() > 50 && ((state = level.getBlockState(blockpos1)).isAir() || ScorchedGeyserFeature.isDirt((BlockState)state) || !state.getFluidState().isEmpty())) {
                    float f2;
                    float f1 = (float)(Math.cos(hillRot) * (double)dx - Math.sin(hillRot) * (double)dz);
                    float dist = f1 * f1 / (scaleX * scaleX) + (f2 = (float)(Math.sin(hillRot) * (double)dx + Math.cos(hillRot) * (double)dz)) * f2 / (scaleZ * scaleZ);
                    if (dist <= (float)(k1 * k1)) {
                        BlockState above = level.getBlockState(blockpos1.above());
                        if (above.isAir()) {
                            this.setBlock((LevelWriter)level, blockpos1, ((Block)BlockInit.SCORCHED_GRASS_SOIL.get()).defaultBlockState());
                        } else if (level.getBlockState(blockpos1.above(2)).isAir() || level.getBlockState(blockpos1.above(3)).isAir()) {
                            this.setBlock((LevelWriter)level, blockpos1, ((Block)BlockInit.SCORCHED_SOIL.get()).defaultBlockState());
                        }
                    }
                    blockpos1 = blockpos1.below();
                    if (--depthCounter > 0) continue;
                    blockpos1 = blockpos1.below(random.nextInt(5) + 1);
                    depthCounter = random.nextInt(5);
                }
            }
        }
    }

    private void addPool(WorldGenLevel level, BlockPos blockpos, RandomSource random, int radius) {
        int radiusX = (int)((float)radius * Mth.randomBetween((RandomSource)random, (float)0.9f, (float)1.1f));
        int radiusZ = (int)((float)radius * Mth.randomBetween((RandomSource)random, (float)0.9f, (float)1.1f));
        int radiusY = (int)((float)radius * Mth.randomBetween((RandomSource)random, (float)0.9f, (float)1.1f));
        double poolRot = Math.toRadians(random.nextInt(360));
        for (int dx = -radiusX - 5; dx <= radiusX + 5; ++dx) {
            for (int dz = -radiusZ - 5; dz <= radiusZ + 5; ++dz) {
                for (int dy = -radiusY - 5; dy <= 2; ++dy) {
                    double nx = (double)((float)(Math.cos(poolRot) * (double)dx - Math.sin(poolRot) * (double)dz)) / (double)radiusX;
                    double nz = (double)((float)(Math.sin(poolRot) * (double)dx + Math.cos(poolRot) * (double)dz)) / (double)radiusZ;
                    double ny = (double)dy / (double)radiusY;
                    double distSq = nx * nx + ny * ny + nz * nz;
                    double dist = Math.sqrt(distSq);
                    BlockPos pos = blockpos.offset(dx, dy, dz);
                    if (!(dist <= 0.9)) continue;
                    if (dy <= 0) {
                        this.setBlock((LevelWriter)level, pos, Blocks.LAVA.defaultBlockState());
                        if (level.getBlockState(pos.offset(0, -1, 0)).is((Block)BlockInit.SCORCHED_GRASS_SOIL.get())) {
                            this.setBlock((LevelWriter)level, pos.offset(0, -1, 0), ((Block)BlockInit.SCORCHED_SOIL.get()).defaultBlockState());
                        }
                    } else {
                        this.setBlock((LevelWriter)level, pos, Blocks.AIR.defaultBlockState());
                    }
                    ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.stream((Direction[])Direction.values().clone()).toList());
                    directions.remove(Direction.UP);
                    for (Direction direction : directions) {
                        int i;
                        BlockPos pos1 = pos.relative(direction);
                        BlockState blockState = level.getBlockState(pos1);
                        if (blockState.isCollisionShapeFullBlock((BlockGetter)level, pos1) || blockState.is(Blocks.LAVA)) continue;
                        if (dy + direction.getStepY() < 0) {
                            this.setBlock((LevelWriter)level, pos1, ((Block)BlockInit.SCORCHED_SOIL.get()).defaultBlockState());
                            if (!level.getBlockState(pos1.offset(0, -1, 0)).is((Block)BlockInit.SCORCHED_GRASS_SOIL.get())) continue;
                            this.setBlock((LevelWriter)level, pos1.offset(0, -1, 0), ((Block)BlockInit.SCORCHED_SOIL.get()).defaultBlockState());
                            continue;
                        }
                        if (dy + direction.getStepY() != 0 || !level.getBlockState(pos1.above()).isAir()) continue;
                        if (random.nextFloat() < 0.75f) {
                            this.setBlock((LevelWriter)level, pos1, ((Block)BlockInit.SCORCHED_GRASS_SOIL.get()).defaultBlockState());
                            continue;
                        }
                        for (i = 0; i < random.nextInt(1, 3); ++i) {
                            this.setBlock((LevelWriter)level, pos1.offset(0, -i, 0), ((Block)BlockInit.SULFUR_BLOCK.get()).defaultBlockState());
                            for (Direction direction1 : Direction.values()) {
                                BlockPos pos2 = pos1.relative(direction1);
                                if (!level.getBlockState(pos2).isAir() || !(random.nextFloat() < 0.15f)) continue;
                                this.setBlock((LevelWriter)level, pos2, (BlockState)((CrystalClusterBlock)((Object)BlockInit.SULFUR_CRYSTAL_CLUSTER.get())).defaultBlockState().setValue((Property)CrystalClusterBlock.FACING, (Comparable)direction1));
                            }
                        }
                        if (!level.getBlockState(pos1.offset(0, -i, 0)).isAir()) continue;
                        this.setBlock((LevelWriter)level, pos1.offset(0, -i, 0), (BlockState)((CrystalClusterBlock)((Object)BlockInit.SULFUR_CRYSTAL_CLUSTER.get())).defaultBlockState().setValue((Property)CrystalClusterBlock.FACING, (Comparable)Direction.DOWN));
                    }
                }
            }
        }
    }
}

