/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.stln.magitech.Config;
import net.stln.magitech.MagitechRegistries;
import net.stln.magitech.advancement.CriterionInit;
import net.stln.magitech.biome.BiomeInit;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.compat.curios.ValidatorInit;
import net.stln.magitech.compat.modonomicon.PageInit;
import net.stln.magitech.data.DataMapTypeInit;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.EntityInit;
import net.stln.magitech.entity.mob_effect.MobEffectInit;
import net.stln.magitech.entity.status.AttributeInit;
import net.stln.magitech.event.EventInit;
import net.stln.magitech.fluid.FluidInit;
import net.stln.magitech.gui.GuiInit;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.item.ItemPropertyInit;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.creative_tab.CreativeTabInit;
import net.stln.magitech.item.fluid.FluidContainerMatcherInit;
import net.stln.magitech.item.tool.material.MaterialInit;
import net.stln.magitech.item.tool.register.ToolMaterialRegister;
import net.stln.magitech.item.tool.upgrade.UpgradeInit;
import net.stln.magitech.loot.LootFunctionInit;
import net.stln.magitech.magic.spell.SpellInit;
import net.stln.magitech.particle.ParticleInit;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.worldgen.WorldGenInit;
import net.stln.magitech.worldgen.tree.TreeGrowerInit;
import org.slf4j.Logger;

@Mod(value="magitech")
public class Magitech {
    public static final String MOD_ID = "magitech";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Magitech(IEventBus modEventBus, ModContainer modContainer) {
        MagitechRegistries.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::commonSetup);
        ComponentInit.registerComponents(modEventBus);
        BlockInit.registerBlocks(modEventBus);
        ItemInit.registerItems(modEventBus);
        FluidInit.registerFluids(modEventBus);
        AttributeInit.registerEntityAttributes(modEventBus);
        CreativeTabInit.registerCreativeTabs(modEventBus);
        CriterionInit.registerCriteria(modEventBus);
        Element.registerElements();
        DataMapTypeInit.registerDataMapTypes(modEventBus);
        EntityInit.registerModEntities(modEventBus);
        GuiInit.registerMenus(modEventBus);
        LootFunctionInit.registerFunctions(modEventBus);
        MaterialInit.registerMaterials(modEventBus);
        MobEffectInit.registerMobEffects(modEventBus);
        ParticleInit.registerParticleClient(modEventBus);
        RecipeInit.registerRecipes(modEventBus);
        SoundInit.registerSoundEvents(modEventBus);
        SpellInit.registerSpells(modEventBus);
        FluidContainerMatcherInit.registerFluidContainerMatchers(modEventBus);
        ToolMaterialRegister.init();
        TreeGrowerInit.registerTrunkPlacerTypes(modEventBus);
        UpgradeInit.registerUpgrades();
        ValidatorInit.registerValidators();
        WorldGenInit.registerFeatures(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BlockInit.registerStrippableBlocks();
        BiomeInit.registerBiomeRegions(event);
        PageInit.registerPages();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="magitech", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityInit.registerModEntitiesRenderer();
            EventInit.registerClientEvent();
            ItemPropertyInit.registerItemProperties();
            PageInit.registerRenderers();
            FluidInit.registerFluidRenderTypes();
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            ParticleInit.registerParticleFactories(event);
        }
    }
}

