/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.biome;

import com.mojang.blaze3d.shaders.FogShape;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.stln.magitech.biome.BiomeInit;
import net.stln.magitech.util.ClientHelper;

@EventBusSubscriber(modid="magitech")
public class RenderFogEvent {
    public static final float LERP_SPEED = 0.002f;
    public static float currentNearPlane = 256.0f;
    public static float targetNearPlane = 256.0f;
    public static float currentFarPlane = 256.0f;
    public static float targetFarPlane = 256.0f;

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        ClientHelper.getOptionalPlayer().ifPresent(player -> {
            BlockPos pos;
            Level level = player.level();
            if (level.getBiome(pos = player.blockPosition()).is(BiomeInit.MISTJADE_FOREST)) {
                targetNearPlane = 10.0f;
                targetFarPlane = 100.0f;
            } else if (level.getBiome(pos).is(BiomeInit.SCORCHED_PLAINS)) {
                targetNearPlane = 0.0f;
                targetFarPlane = 125.0f;
            } else {
                targetNearPlane = event.getNearPlaneDistance();
                targetFarPlane = event.getFarPlaneDistance();
            }
            currentFarPlane += (targetFarPlane - currentFarPlane) * 0.002f;
            currentNearPlane += (targetNearPlane - currentNearPlane) * 0.002f;
            if ((currentNearPlane != event.getNearPlaneDistance() || currentFarPlane != event.getFarPlaneDistance()) && player.getEyeInFluidType() == NeoForgeMod.EMPTY_TYPE.value()) {
                event.setCanceled(true);
                event.setNearPlaneDistance(currentNearPlane);
                event.setFarPlaneDistance(currentFarPlane);
                event.setFogShape(FogShape.SPHERE);
            }
        });
    }
}

