/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.block_entity.AlchemetricPylonBlockEntity;

public class AlchemetricPylonBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)2.0, (double)7.0, (double)13.0, (double)10.0, (double)9.0), Block.box((double)7.0, (double)2.0, (double)3.0, (double)9.0, (double)10.0, (double)13.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)});
    public static final MapCodec<AlchemetricPylonBlock> CODEC = AlchemetricPylonBlock.simpleCodec(AlchemetricPylonBlock::new);

    public AlchemetricPylonBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AlchemetricPylonBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return this.createTicker(level, blockEntityType, BlockInit.ALCHEMETRIC_PYLON_ENTITY.get());
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AlchemetricPylonBlockEntity) {
            AlchemetricPylonBlockEntity pylonBlockEntity = (AlchemetricPylonBlockEntity)blockEntity;
            pylonBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlchemetricPylonBlockEntity) {
            AlchemetricPylonBlockEntity pylonBlockEntity = (AlchemetricPylonBlockEntity)blockEntity;
            if (pylonBlockEntity.inventory.getStackInSlot(0).isEmpty() && !stack.isEmpty()) {
                pylonBlockEntity.inventory.insertItem(0, stack.copy(), false);
                stack.shrink(1);
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 2.0f);
            } else if (stack.isEmpty()) {
                stackOnPedestal = pylonBlockEntity.inventory.extractItem(0, 1, false);
                player.setItemInHand(InteractionHand.MAIN_HAND, stackOnPedestal);
                pylonBlockEntity.clearContents();
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                stackOnPedestal = pylonBlockEntity.inventory.extractItem(0, 1, false);
                if (stack.getCount() == 1) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, stackOnPedestal);
                } else {
                    player.addItem(stackOnPedestal);
                }
                pylonBlockEntity.clearContents();
                pylonBlockEntity.inventory.insertItem(0, stack.copy(), false);
                stack.shrink(1);
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    protected <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends AlchemetricPylonBlockEntity> clientType) {
        return AlchemetricPylonBlock.createTickerHelper(serverType, clientType, (pLevel1, pPos, pState1, pBlockEntity) -> {
            if (pLevel1.isClientSide) {
                pBlockEntity.clientTick(pLevel1, pPos, pState1, (AlchemetricPylonBlockEntity)pBlockEntity);
            } else {
                pBlockEntity.serverTick(pLevel1, pPos, pState1, (AlchemetricPylonBlockEntity)pBlockEntity);
            }
        });
    }
}

