/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.damage.DamageTypeInit;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import org.joml.Vector3f;

public class ManaBerryBushBlock
extends SweetBerryBushBlock {
    public ManaBerryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ItemInit.MANA_BERRIES.get());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (i > 1) {
            int j = 1 + level.random.nextInt(2);
            ManaBerryBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemInit.MANA_BERRIES.get(), j + (flag ? 1 : 0)));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((long)level.random.nextInt(200) <= level.getGameTime() % 200L) {
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
            double d0 = vec3.x + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
            double d1 = vec3.y + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
            double d2 = vec3.z + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
            double d3 = Mth.nextDouble((RandomSource)level.random, (double)-0.05, (double)0.05);
            double d4 = Mth.nextDouble((RandomSource)level.random, (double)0.0, (double)0.1);
            double d5 = Mth.nextDouble((RandomSource)level.random, (double)-0.05, (double)0.05);
            level.addParticle((ParticleOptions)new UnstableSquareParticleEffect(new Vector3f(0.7f, 1.0f, 0.2f), new Vector3f(0.5f, 1.0f, 1.0f), 0.5f, 1, 0.0f), d0, d1, d2, d3, d4, d5);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && entity.getType() != EntityType.FOX && entity.getType() != EntityType.BEE) {
            entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(level.isClientSide || (Integer)state.getValue((Property)AGE) <= 0 || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                double d0 = Math.abs(entity.getX() - entity.xOld);
                double d1 = Math.abs(entity.getZ() - entity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entity.hurt(level.damageSources().source(DamageTypeInit.MANA_BERRY_BUSH), 1.0f);
                }
            }
        }
    }
}

