/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.stln.magitech.block.AlchemetricPylonBlock;
import net.stln.magitech.block.block_entity.ManaVesselBlockEntity;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import org.joml.Vector3f;

public class ManaVesselBlock
extends BaseEntityBlock {
    public static final MapCodec<AlchemetricPylonBlock> CODEC = ManaVesselBlock.simpleCodec(AlchemetricPylonBlock::new);

    protected ManaVesselBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ManaVesselBlockEntity(blockPos, blockState);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int i;
        super.animateTick(state, level, pos, random);
        Vec3 center = pos.getCenter();
        for (i = 0; i < 2; ++i) {
            double x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
            double y = center.y + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
            double z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, 3, 0.0f), x, y, z, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 2; ++i) {
            int direction = i == 0 ? -1 : 1;
            double x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            double y = center.y + 0.5 * (double)direction;
            double z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, 3, Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f)), x, y, z, 0.0, 0.03 * (double)direction, 0.0);
        }
        for (i = 0; i < 4; ++i) {
            double x2 = center.x + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5);
            double y2 = center.y + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5);
            double z2 = center.z + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5);
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 0.5f, 1, Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f)), x2, y2, z2, 0.0, 0.03, 0.0);
        }
    }
}

