/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.block_entity.ZardiusCrucibleBlockEntity;
import net.stln.magitech.util.TickScheduler;
import org.jetbrains.annotations.Nullable;

public class ZardiusCrucibleBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)4.0, (double)14.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)2.0), Block.box((double)2.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)12.0, (double)0.0, (double)14.0, (double)14.0, (double)4.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)4.0), Block.box((double)14.0, (double)4.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0)});
    public static final MapCodec<ZardiusCrucibleBlock> CODEC = ZardiusCrucibleBlock.simpleCodec(ZardiusCrucibleBlock::new);

    public ZardiusCrucibleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.isOnFire(pState, pLevel, pPos)) {
            this.addBoilEffect(pState, pLevel, pPos, pRandom);
        }
    }

    public boolean isOnFire(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState belowBlock = pLevel.getBlockState(pPos.below());
        if (belowBlock.getBlock().equals(Blocks.LAVA) || belowBlock.getBlock().equals(Blocks.FIRE) || belowBlock.getBlock().equals(Blocks.SOUL_FIRE)) {
            return true;
        }
        return (belowBlock.getBlock().equals(Blocks.CAMPFIRE) || belowBlock.getBlock().equals(Blocks.SOUL_CAMPFIRE)) && (Boolean)belowBlock.getValue((Property)BlockStateProperties.LIT) != false;
    }

    private void addBoilEffect(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        ZardiusCrucibleBlockEntity blockEntity = (ZardiusCrucibleBlockEntity)pLevel.getBlockEntity(pPos);
        for (int i = 0; i < 2; ++i) {
            if (blockEntity.fluidTank.isEmpty()) continue;
            float height = (float)blockEntity.getFluidAnim(blockEntity, 0.0f) / (float)blockEntity.fluidTank.getCapacity() * 0.75f + 0.2f;
            double d0 = (double)pPos.getX() + (double)pRandom.nextFloat() * 0.8 + 0.1;
            double d1 = (double)pPos.getY() + (double)height;
            double d2 = (double)pPos.getZ() + (double)pRandom.nextFloat() * 0.8 + 0.1;
            if (blockEntity.fluidTank.getFluid().getFluid().isSame((Fluid)Fluids.LAVA)) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, d0, d1, d2, pRandom.nextGaussian() * 0.005, pRandom.nextGaussian() * 0.005, pRandom.nextGaussian() * 0.005);
                continue;
            }
            pLevel.addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0, d1, d2, pRandom.nextGaussian() * 0.005, pRandom.nextGaussian() * 0.005, pRandom.nextGaussian() * 0.005);
            TickScheduler.schedule(1, () -> pLevel.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, d0, d1, d2, pRandom.nextGaussian() * 0.005, pRandom.nextGaussian() * 0.005, pRandom.nextGaussian() * 0.005), pLevel.isClientSide);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ZardiusCrucibleBlockEntity(blockPos, blockState);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof ZardiusCrucibleBlockEntity) {
            ZardiusCrucibleBlockEntity pylonBlockEntity = (ZardiusCrucibleBlockEntity)blockEntity;
            pylonBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ZardiusCrucibleBlockEntity) {
            ZardiusCrucibleBlockEntity zardiusCrucibleBlockEntity = (ZardiusCrucibleBlockEntity)entity;
            ItemStack itemInHand = player.getItemInHand(hand);
            zardiusCrucibleBlockEntity.addItem(player, itemInHand, 1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ZardiusCrucibleBlock.createTickerHelper(pBlockEntityType, BlockInit.ZARDIUS_CRUCIBLE_ENTITY.get(), (pLevel1, pPos, pState1, pBlockEntity) -> {
            if (pLevel1.isClientSide) {
                pBlockEntity.clientTick(pLevel1, pPos, pState1);
            } else {
                pBlockEntity.serverTick(pLevel1, pPos, pState1);
            }
        });
    }
}

