/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.block.block_entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.stln.magitech.Magitech;
import net.stln.magitech.block.AthanorPillarBlock;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.block.ManaNodeBlock;
import net.stln.magitech.block.block_entity.AlchemetricPylonBlockEntity;
import net.stln.magitech.block.block_entity.ManaVesselBlockEntity;
import net.stln.magitech.particle.particle_option.ManaZapParticleEffect;
import net.stln.magitech.particle.particle_option.SquareParticleEffect;
import net.stln.magitech.particle.particle_option.UnstableSquareParticleEffect;
import net.stln.magitech.recipe.AthanorPillarInfusionRecipe;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.input.GroupedMultiStackRecipeInput;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.EffectUtil;
import net.stln.magitech.util.StructureHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AthanorPillarBlockEntity
extends BlockEntity {
    private static final ResourceLocation STRUCTURE = Magitech.id("athanor_pillar_altar");
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            AthanorPillarBlockEntity.this.setChanged();
            if (!AthanorPillarBlockEntity.this.level.isClientSide()) {
                AthanorPillarBlockEntity.this.level.sendBlockUpdated(AthanorPillarBlockEntity.this.getBlockPos(), AthanorPillarBlockEntity.this.getBlockState(), AthanorPillarBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    public int tickCounter = 0;
    int craftingProgress = 0;
    int craftingTotalTime = 200;

    public AthanorPillarBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockInit.ATHANOR_PILLAR_ENTITY.get(), pos, blockState);
    }

    public static BlockPos getPylonPos(BlockPos pos, int i, int j) {
        return switch (4 * i + j) {
            case 0 -> pos.offset(2, 0, 2);
            case 1 -> pos.offset(-2, 0, 2);
            case 2 -> pos.offset(2, 0, -2);
            case 3 -> pos.offset(-2, 0, -2);
            case 4 -> pos.offset(3, 2, 0);
            case 5 -> pos.offset(0, 2, 3);
            case 6 -> pos.offset(-3, 2, 0);
            case 7 -> pos.offset(0, 2, -3);
            case 8 -> pos.offset(4, 3, 4);
            case 9 -> pos.offset(-4, 3, 4);
            case 10 -> pos.offset(4, 3, -4);
            case 11 -> pos.offset(-4, 3, -4);
            default -> null;
        };
    }

    public static BlockPos getVesselPos(BlockPos pos, int i) {
        return switch (i) {
            case 0 -> pos.offset(3, 0, 3);
            case 1 -> pos.offset(-3, 0, 3);
            case 2 -> pos.offset(3, 0, -3);
            case 3 -> pos.offset(-3, 0, -3);
            case 4 -> pos.offset(0, 5, 0);
            default -> null;
        };
    }

    private static void zapParticle(Level level, BlockPos pos, RandomSource random, Vector3f color) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        BlockPos pillar = new BlockPos((Vec3i)pos);
        BlockPos posBottom1 = AthanorPillarBlockEntity.getPylonPos(pos, 0, 0);
        BlockPos posBottom2 = AthanorPillarBlockEntity.getPylonPos(pos, 0, 1);
        BlockPos posBottom3 = AthanorPillarBlockEntity.getPylonPos(pos, 0, 2);
        BlockPos posBottom4 = AthanorPillarBlockEntity.getPylonPos(pos, 0, 3);
        BlockPos posMid1 = AthanorPillarBlockEntity.getPylonPos(pos, 1, 0);
        BlockPos posMid2 = AthanorPillarBlockEntity.getPylonPos(pos, 1, 1);
        BlockPos posMid3 = AthanorPillarBlockEntity.getPylonPos(pos, 1, 2);
        BlockPos posMid4 = AthanorPillarBlockEntity.getPylonPos(pos, 1, 3);
        BlockPos posTop1 = AthanorPillarBlockEntity.getPylonPos(pos, 2, 0);
        BlockPos posTop2 = AthanorPillarBlockEntity.getPylonPos(pos, 2, 1);
        BlockPos posTop3 = AthanorPillarBlockEntity.getPylonPos(pos, 2, 2);
        BlockPos posTop4 = AthanorPillarBlockEntity.getPylonPos(pos, 2, 3);
        Vector3f vessel1 = vec3.add(3.0, 1.0, 3.0).toVector3f();
        Vector3f vessel2 = vec3.add(-3.0, 1.0, 3.0).toVector3f();
        Vector3f vessel3 = vec3.add(3.0, 1.0, -3.0).toVector3f();
        Vector3f vessel4 = vec3.add(-3.0, 1.0, -3.0).toVector3f();
        Vector3f vessel5 = vec3.add(0.0, 4.0, 0.0).toVector3f();
        Vector3f bottom1 = posBottom1.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f bottom2 = posBottom2.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f bottom3 = posBottom3.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f bottom4 = posBottom4.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f mid1 = posMid1.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f mid2 = posMid2.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f mid3 = posMid3.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f mid4 = posMid4.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f top1 = posTop1.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f top2 = posTop2.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f top3 = posTop3.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        Vector3f top4 = posTop4.getCenter().add(0.0, 0.6, 0.0).toVector3f();
        boolean bottomFlag1 = AthanorPillarBlockEntity.hasItemInInventory(level, posBottom1);
        boolean bottomFlag2 = AthanorPillarBlockEntity.hasItemInInventory(level, posBottom2);
        boolean bottomFlag3 = AthanorPillarBlockEntity.hasItemInInventory(level, posBottom3);
        boolean bottomFlag4 = AthanorPillarBlockEntity.hasItemInInventory(level, posBottom4);
        boolean midFlag1 = AthanorPillarBlockEntity.hasItemInInventory(level, posMid1);
        boolean midFlag2 = AthanorPillarBlockEntity.hasItemInInventory(level, posMid2);
        boolean midFlag3 = AthanorPillarBlockEntity.hasItemInInventory(level, posMid3);
        boolean midFlag4 = AthanorPillarBlockEntity.hasItemInInventory(level, posMid4);
        boolean topFlag1 = AthanorPillarBlockEntity.hasItemInInventory(level, posTop1);
        boolean topFlag2 = AthanorPillarBlockEntity.hasItemInInventory(level, posTop2);
        boolean topFlag3 = AthanorPillarBlockEntity.hasItemInInventory(level, posTop3);
        boolean topFlag4 = AthanorPillarBlockEntity.hasItemInInventory(level, posTop4);
        if (bottomFlag1) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom1, 1.0f, 1, 0.0f), (double)vessel1.x, (double)vessel1.y, (double)vessel1.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom1, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posBottom1);
        } else {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, vessel1, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
        }
        if (bottomFlag2) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom2, 1.0f, 1, 0.0f), (double)vessel2.x, (double)vessel2.y, (double)vessel2.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom2, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posBottom2);
        } else {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, vessel2, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
        }
        if (bottomFlag3) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom3, 1.0f, 1, 0.0f), (double)vessel3.x, (double)vessel3.y, (double)vessel3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom3, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posBottom3);
        } else {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, vessel3, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
        }
        if (bottomFlag4) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom4, 1.0f, 1, 0.0f), (double)vessel4.x, (double)vessel4.y, (double)vessel4.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, bottom4, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posBottom4);
        } else {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, vessel4, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
        }
        if (midFlag1) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid1, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid1, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posMid1);
        }
        if (midFlag2) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid2, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid2, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posMid2);
        }
        if (midFlag3) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid3, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid3, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posMid3);
        }
        if (midFlag4) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid4, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, mid4, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posMid4);
        }
        if (topFlag1) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top1, 1.0f, 1, 0.0f), (double)vessel1.x, (double)vessel1.y, (double)vessel1.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top1, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posTop1);
        }
        if (topFlag2) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top2, 1.0f, 1, 0.0f), (double)vessel2.x, (double)vessel2.y, (double)vessel2.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top2, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posTop2);
        }
        if (topFlag3) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top3, 1.0f, 1, 0.0f), (double)vessel3.x, (double)vessel3.y, (double)vessel3.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top3, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posTop3);
        }
        if (topFlag4) {
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top4, 1.0f, 1, 0.0f), (double)vessel4.x, (double)vessel4.y, (double)vessel4.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, top4, 1.0f, 1, 0.0f), (double)vessel5.x, (double)vessel5.y, (double)vessel5.z, 0.0, 0.0, 0.0), 0.3f);
            AthanorPillarBlockEntity.itemParticle(level, random, posTop4);
        }
        AthanorPillarBlockEntity.randomParticle(random, () -> level.addAlwaysVisibleParticle((ParticleOptions)new ManaZapParticleEffect(color, color, vessel5, 1.0f, 1, 0.0f), vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0), 0.3f);
        AthanorPillarBlockEntity.itemParticle(level, random, pillar);
        AthanorPillarBlockEntity.nodeParticle(level, random, vessel1);
        AthanorPillarBlockEntity.nodeParticle(level, random, vessel2);
        AthanorPillarBlockEntity.nodeParticle(level, random, vessel3);
        AthanorPillarBlockEntity.nodeParticle(level, random, vessel4);
        AthanorPillarBlockEntity.nodeParticle(level, random, vessel5);
    }

    private static boolean hasItemInInventory(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlchemetricPylonBlockEntity) {
            AlchemetricPylonBlockEntity blockEntity2 = (AlchemetricPylonBlockEntity)blockEntity;
            return !blockEntity2.inventory.getStackInSlot(0).isEmpty();
        }
        blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AthanorPillarBlockEntity) {
            AthanorPillarBlockEntity blockEntity3 = (AthanorPillarBlockEntity)blockEntity;
            return !blockEntity3.inventory.getStackInSlot(0).isEmpty();
        }
        return false;
    }

    private static void itemParticle(Level level, RandomSource random, BlockPos blockPos) {
        double z;
        double y;
        double x;
        int i;
        Vec3 center = blockPos.getCenter();
        for (i = 0; i < 5; ++i) {
            x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.4, (double)0.4);
            y = center.y + 0.3;
            z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.4, (double)0.4);
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 0.5f, 2, Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f)), x, y, z, (x - center.x) / 40.0, Mth.nextDouble((RandomSource)random, (double)0.0, (double)0.075), (z - center.z) / 40.0);
        }
        for (i = 0; i < 3; ++i) {
            x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            y = center.y + 0.4 + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, 3, 0.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void nodeParticle(Level level, RandomSource random, Vector3f blockPos) {
        double z;
        double y;
        double x;
        int i;
        for (i = 0; i < 5; ++i) {
            x = (double)blockPos.x + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            y = blockPos.y;
            z = (double)blockPos.z + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            BlockState blockState = level.getBlockState(BlockPos.containing((double)blockPos.x, (double)blockPos.y, (double)blockPos.z));
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 0.5f, 2, Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f)), x, y, z, (x - (double)blockPos.x) / 40.0, Mth.nextDouble((RandomSource)random, (double)0.0, (double)0.075) * (double)(blockState.hasProperty((Property)ManaNodeBlock.FACING) ? ((Direction)blockState.getValue((Property)ManaNodeBlock.FACING)).getStepY() : 1), (z - (double)blockPos.z) / 40.0);
        }
        for (i = 0; i < 3; ++i) {
            x = (double)blockPos.x + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            y = (double)blockPos.y + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            z = (double)blockPos.z + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
            level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, 3, 0.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void randomParticle(RandomSource random, Runnable particleAction, float chance) {
        if (random.nextFloat() < chance) {
            particleAction.run();
        }
    }

    private static void reset(Level level, BlockPos pos, BlockState state, AthanorPillarBlockEntity blockEntity) {
        state = (BlockState)state.setValue((Property)AthanorPillarBlock.LIT, (Comparable)Boolean.valueOf(false));
        level.setBlock(pos, state, 3);
        AthanorPillarBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        blockEntity.craftingProgress = 0;
    }

    public static boolean hasCorrectStructure(Level level, BlockPos pos) {
        return StructureHelper.checkMultiblock(level, STRUCTURE, pos.subtract(new Vec3i(0, 1, 0)));
    }

    public static BlockPos detectIncorrectStructurePos(Level level, BlockPos pos) {
        return StructureHelper.detectMultiblockError(level, STRUCTURE, pos.subtract(new Vec3i(0, 1, 0)), Rotation.NONE, false);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, AthanorPillarBlockEntity blockEntity) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof AthanorPillarBlock) {
            AthanorPillarBlock athanorPillarBlock = (AthanorPillarBlock)block;
            if (AthanorPillarBlockEntity.hasCorrectStructure(level, pos)) {
                ArrayList<List<ItemStack>> stacks = new ArrayList<List<ItemStack>>();
                for (int i = 0; i < 3; ++i) {
                    ArrayList<ItemStack> group = new ArrayList<ItemStack>();
                    for (int j = 0; j < 4; ++j) {
                        group.add(((AlchemetricPylonBlockEntity)level.getBlockEntity((BlockPos)AthanorPillarBlockEntity.getPylonPos((BlockPos)pos, (int)i, (int)j))).inventory.getStackInSlot(0));
                    }
                    stacks.add(group);
                }
                GroupedMultiStackRecipeInput input = new GroupedMultiStackRecipeInput(stacks);
                RecipeManager manager = level.getRecipeManager();
                Optional recipeHolder = manager.getRecipeFor(RecipeInit.ATHANOR_PILLAR_INFUSION_TYPE.get(), (RecipeInput)input, level);
                if (recipeHolder.isPresent() && blockEntity.inventory.getStackInSlot(0).is(((AthanorPillarInfusionRecipe)((RecipeHolder)recipeHolder.get()).value()).getBase().getItem())) {
                    int i;
                    boolean flag = true;
                    for (i = 0; i < 5; ++i) {
                        BlockPos vesselPos = AthanorPillarBlockEntity.getVesselPos(pos, i);
                        if (((ManaVesselBlockEntity)level.getBlockEntity(vesselPos)).getMana() >= ((AthanorPillarInfusionRecipe)((RecipeHolder)recipeHolder.get()).value()).getMana() / 5) continue;
                        flag = false;
                    }
                    if (flag) {
                        if (blockEntity.craftingProgress == blockEntity.craftingTotalTime) {
                            blockEntity.inventory.setStackInSlot(0, ((AthanorPillarInfusionRecipe)((RecipeHolder)recipeHolder.get()).value()).assemble(input, (HolderLookup.Provider)level.registryAccess()));
                            for (i = 0; i < 3; ++i) {
                                for (int j = 0; j < 4; ++j) {
                                    BlockPos pylonPos = AthanorPillarBlockEntity.getPylonPos(pos, i, j);
                                    ((AlchemetricPylonBlockEntity)level.getBlockEntity((BlockPos)pylonPos)).inventory.setStackInSlot(0, ItemStack.EMPTY);
                                    AthanorPillarBlockEntity.setChanged((Level)level, (BlockPos)pylonPos, (BlockState)level.getBlockState(pylonPos));
                                }
                            }
                            for (i = 0; i < 5; ++i) {
                                BlockPos vesselPos = AthanorPillarBlockEntity.getVesselPos(pos, i);
                                BlockState state1 = level.getBlockState(vesselPos);
                                ((ManaVesselBlockEntity)level.getBlockEntity(vesselPos)).subMana(((AthanorPillarInfusionRecipe)((RecipeHolder)recipeHolder.get()).value()).getMana() / 5);
                                AthanorPillarBlockEntity.setChanged((Level)level, (BlockPos)vesselPos, (BlockState)state1);
                                level.sendBlockUpdated(vesselPos, state1, state1, 3);
                                blockEntity.craftingProgress = 0;
                            }
                            blockEntity.craftingProgress = 0;
                            AthanorPillarBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                        }
                        ++blockEntity.craftingProgress;
                        if (blockEntity.craftingProgress % 5 == 0) {
                            level.playSound(null, pos, SoundInit.ATHANOR_PILLAR_INFUSION.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
                        }
                        if (level.random.nextBoolean() && level.random.nextBoolean()) {
                            level.playSound(null, pos, SoundInit.ATHANOR_PILLAR_ZAP.get(), SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)level.random, (float)0.9f, (float)1.1f));
                        }
                        BlockState old = state;
                        state = (BlockState)state.setValue((Property)AthanorPillarBlock.LIT, (Comparable)Boolean.valueOf(true));
                        level.setBlock(pos, state, 3);
                        AthanorPillarBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                        level.sendBlockUpdated(pos, old, state, 3);
                    } else {
                        AthanorPillarBlockEntity.reset(level, pos, state, blockEntity);
                    }
                } else {
                    AthanorPillarBlockEntity.reset(level, pos, state, blockEntity);
                }
            }
        }
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, AthanorPillarBlockEntity blockEntity) {
        BlockPos errorPos;
        ++this.tickCounter;
        RandomSource random = level.random;
        if (AthanorPillarBlockEntity.hasCorrectStructure(level, pos)) {
            double x;
            int i;
            Vec3 center = pos.getCenter();
            for (i = 0; i < 3; ++i) {
                x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
                y = center.y + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
                z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 1.0f, 3, 0.0f), x, y, z, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 3; ++i) {
                x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
                y = center.y + 0.5;
                z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.2, (double)0.2);
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 0.5f, 1, Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f)), x, y, z, 0.0, Mth.nextDouble((RandomSource)random, (double)0.0, (double)0.05), 0.0);
            }
            for (i = 0; i < 3; ++i) {
                double x2 = center.x + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5);
                double y2 = center.y + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5);
                double z2 = center.z + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5);
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.8f, 1.0f, 0.7f), new Vector3f(0.0f, 1.0f, 0.9f), 0.5f, 1, Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f)), x2, y2, z2, 0.0, 0.03, 0.0);
            }
            Vector3f color = new Vector3f(1.0f, 1.0f, 1.0f);
            if ((long)level.random.nextInt(100) <= level.getGameTime() % 100L) {
                Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
                double d0 = vec3.x + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
                double d1 = vec3.y + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
                double d2 = vec3.z + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * 0.4;
                double d3 = Mth.nextDouble((RandomSource)level.random, (double)-0.2, (double)0.2);
                double d4 = Mth.nextDouble((RandomSource)level.random, (double)-0.2, (double)0.2);
                double d5 = Mth.nextDouble((RandomSource)level.random, (double)-0.2, (double)0.2);
                level.addParticle((ParticleOptions)new UnstableSquareParticleEffect(new Vector3f(0.7f, 1.0f, 0.5f), new Vector3f(0.0f, 1.0f, 0.8f), 1.0f, 1, 0.0f), d0, d1, d2, d3, d4, d5);
                if ((double)random.nextFloat() < 0.2) {
                    level.addParticle((ParticleOptions)new ManaZapParticleEffect(color, color, new Vector3f((float)((double)Mth.nextFloat((RandomSource)level.random, (float)-2.0f, (float)2.0f) + vec3.x), (float)((double)Mth.nextFloat((RandomSource)level.random, (float)-2.0f, (float)2.0f) + vec3.y), (float)((double)Mth.nextFloat((RandomSource)level.random, (float)-2.0f, (float)2.0f) + vec3.z)), 1.0f, 2, 0.0f), vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
                }
            }
            if (AthanorPillarBlockEntity.hasItemInInventory(level, pos) && ((Boolean)state.getValue((Property)AthanorPillarBlock.LIT)).booleanValue() && random.nextBoolean()) {
                AthanorPillarBlockEntity.zapParticle(level, pos, random, color);
            }
        } else if ((double)random.nextFloat() < 0.2 && (errorPos = AthanorPillarBlockEntity.detectIncorrectStructurePos(level, pos)) != null) {
            Vec3 center = errorPos.getCenter();
            double x = center.x + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
            y = center.y + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
            z = center.z + Mth.nextDouble((RandomSource)random, (double)-0.6, (double)0.6);
            Vec3 v1 = Vec3.atLowerCornerOf((Vec3i)errorPos);
            Vec3 v2 = v1.add(1.0, 0.0, 0.0);
            Vec3 v3 = v1.add(1.0, 0.0, 1.0);
            Vec3 v4 = v1.add(0.0, 0.0, 1.0);
            Vec3 v5 = v1.add(0.0, 1.0, 0.0);
            Vec3 v6 = v1.add(1.0, 1.0, 0.0);
            Vec3 v7 = v1.add(1.0, 1.0, 1.0);
            Vec3 v8 = v1.add(0.0, 1.0, 1.0);
            SquareParticleEffect effect = new SquareParticleEffect(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), 1.0f, 1, 0.0f);
            EffectUtil.lineEffect(level, effect, new Vec3(x, y, z), pos.getCenter(), 5, true);
            EffectUtil.lineEffect(level, effect, v1, v2, 7, true);
            EffectUtil.lineEffect(level, effect, v2, v3, 7, true);
            EffectUtil.lineEffect(level, effect, v3, v4, 7, true);
            EffectUtil.lineEffect(level, effect, v4, v1, 7, true);
            EffectUtil.lineEffect(level, effect, v5, v6, 7, true);
            EffectUtil.lineEffect(level, effect, v6, v7, 7, true);
            EffectUtil.lineEffect(level, effect, v7, v8, 7, true);
            EffectUtil.lineEffect(level, effect, v8, v5, 7, true);
            EffectUtil.lineEffect(level, effect, v1, v5, 7, true);
            EffectUtil.lineEffect(level, effect, v2, v6, 7, true);
            EffectUtil.lineEffect(level, effect, v3, v7, 7, true);
            EffectUtil.lineEffect(level, effect, v4, v8, 7, true);
        }
        if (blockEntity.craftingProgress > blockEntity.craftingTotalTime - 3) {
            for (int i = 0; i < 100; ++i) {
                Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
                double d0 = Mth.nextDouble((RandomSource)level.random, (double)-2.5, (double)2.5);
                double d1 = Mth.nextDouble((RandomSource)level.random, (double)-2.0, (double)2.0);
                double d2 = Mth.nextDouble((RandomSource)level.random, (double)-2.5, (double)2.5);
                d0 *= Math.abs(d0);
                d1 *= Math.abs(d1);
                d2 *= Math.abs(d2);
                double d3 = Mth.nextDouble((RandomSource)level.random, (double)-0.05, (double)0.05);
                double d4 = Mth.nextDouble((RandomSource)level.random, (double)-0.05, (double)0.05);
                double d5 = Mth.nextDouble((RandomSource)level.random, (double)-0.05, (double)0.05);
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.7f, 1.0f, 0.5f), new Vector3f(0.0f, 1.0f, 0.8f), 1.0f, 2, 0.0f), d0 += vec3.x, d1 += vec3.y + 2.0, d2 += vec3.z, d3, d4, d5);
                level.addParticle((ParticleOptions)new SquareParticleEffect(new Vector3f(0.0f, 1.0f, 0.8f), new Vector3f(0.3f, 0.6f, 1.0f), 1.0f, 2, 0.0f), d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("progress", this.craftingProgress);
        tag.putInt("totalProgress", this.craftingTotalTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.craftingProgress = tag.getInt("progress");
        this.craftingTotalTime = tag.getInt("totalProgress");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

