/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.stln.magitech.Magitech;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.compat.jei.AbstractMagitechRecipeCategory;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.MaterialComponent;
import net.stln.magitech.recipe.PartCuttingRecipe;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import net.stln.magitech.util.ClientHelper;
import org.jetbrains.annotations.NotNull;

public class PartCuttingRecipeCategory
extends AbstractMagitechRecipeCategory<PartCuttingRecipe> {
    public static final ResourceLocation UID = Magitech.id("part_cutting");
    public static final ResourceLocation TEXTURE = Magitech.id("textures/gui/jei_widgets.png");
    public static final RecipeType<PartCuttingRecipe> PART_CUTTING_RECIPE_TYPE = new RecipeType(UID, PartCuttingRecipe.class);

    public PartCuttingRecipeCategory(IDrawable icon) {
        super(icon);
    }

    public PartCuttingRecipeCategory(IGuiHelper helper) {
        this(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(BlockInit.ENGINEERING_WORKBENCH)));
    }

    @NotNull
    public RecipeType<PartCuttingRecipe> getRecipeType() {
        return PART_CUTTING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"recipe.magitech.part_cutting");
    }

    public void draw(@NotNull PartCuttingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        guiGraphics.blit(TEXTURE, 18, 4, 0, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 40, 8, 0, 18, 21, 10);
        guiGraphics.blit(TEXTURE, 65, 4, 36, 0, 18, 18);
    }

    public int getWidth() {
        return 101;
    }

    public int getHeight() {
        return 26;
    }

    @Override
    protected void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull PartCuttingRecipe recipe, @NotNull IFocusGroup focuses, @NotNull RecipeManager recipeManager, @NotNull RegistryAccess access) {
        List<ToolMaterialRecipe> materialRecipes = ClientHelper.getAllRecipes(RecipeInit.TOOL_MATERIAL_TYPE);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (ToolMaterialRecipe materialRecipe : materialRecipes) {
            Ingredient ingredient = (Ingredient)materialRecipe.getIngredients().getFirst();
            for (ItemStack itemStack : ingredient.getItems()) {
                if (itemStack.isEmpty()) continue;
                inputs.add(itemStack.copyWithCount(recipe.inputCount()));
            }
            ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)access).copy();
            resultStack.set(ComponentInit.MATERIAL_COMPONENT, (Object)new MaterialComponent(materialRecipe.getToolMaterial()));
            results.add(resultStack);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 5).addItemStacks(inputs);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 5).addItemStacks(results);
    }
}

