/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.compat.jei;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.stln.magitech.Magitech;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.compat.jei.AbstractMagitechRecipeCategory;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.RecipeInit;
import net.stln.magitech.recipe.ToolMaterialRecipe;
import net.stln.magitech.recipe.ZardiusCrucibleRecipe;
import net.stln.magitech.util.ClientHelper;
import org.jetbrains.annotations.NotNull;

public class ZardiusCrucibleRecipeCategory
extends AbstractMagitechRecipeCategory<ZardiusCrucibleRecipe> {
    public static final ResourceLocation UID = Magitech.id("recipe.magitech.zardius_crucible");
    public static final ResourceLocation TEXTURE = Magitech.id("textures/gui/jei_widgets.png");
    public static final RecipeType<ZardiusCrucibleRecipe> ZARDIUS_CRUCIBLE_RECIPE_TYPE = new RecipeType(UID, ZardiusCrucibleRecipe.class);

    public ZardiusCrucibleRecipeCategory(IDrawable icon) {
        super(icon);
    }

    public ZardiusCrucibleRecipeCategory(IGuiHelper helper) {
        this(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(BlockInit.ZARDIUS_CRUCIBLE)));
    }

    @NotNull
    public RecipeType<ZardiusCrucibleRecipe> getRecipeType() {
        return ZARDIUS_CRUCIBLE_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"recipe.magitech.zardius_crucible");
    }

    public void draw(@NotNull ZardiusCrucibleRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int size = recipe.getIngredients().size();
        for (int i = 0; i < (size == 0 ? 8 : size); ++i) {
            int y;
            int x;
            if (size <= 3) {
                int totalWidth = size * 18;
                int startX = 19 + (36 - totalWidth) / 2;
                x = startX + i * 18;
                y = 13;
            } else if (size == 4) {
                row = i / 2;
                col = i % 2;
                x = 19 + col * 18;
                y = 4 + row * 18;
            } else if (size < 7) {
                row = i / 3;
                col = i % 3;
                totalWidth = 54;
                x = 19 + col * 18 + (36 - totalWidth) / 2;
                y = 4 + row * 18;
            } else {
                row = i / 4;
                col = i % 4;
                totalWidth = 72;
                x = 19 + col * 18 + (36 - totalWidth) / 2;
                y = 4 + row * 18;
            }
            guiGraphics.blit(TEXTURE, x, y, 0, 0, 18, 18);
        }
        guiGraphics.blit(TEXTURE, 73, 13, 18, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 95, 17, 0, 18, 21, 10);
        RegistryAccess access = ClientHelper.getRegistryAccess();
        if (access == null) {
            return;
        }
        guiGraphics.blit(TEXTURE, 120, 13, 36, 0, 18, 18);
        guiGraphics.blit(TEXTURE, 138, 13, 54, 0, 18, 18);
    }

    public int getWidth() {
        return 155;
    }

    public int getHeight() {
        return 44;
    }

    @Override
    protected void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ZardiusCrucibleRecipe recipe, @NotNull IFocusGroup focuses, @NotNull RecipeManager recipeManager, @NotNull RegistryAccess access) {
        List<ToolMaterialRecipe> materialRecipes = ClientHelper.getAllRecipes(RecipeInit.TOOL_MATERIAL_TYPE);
        List<ToolMaterial> materials = materialRecipes.stream().map(ToolMaterialRecipe::getToolMaterial).toList();
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        for (int i = 0; i < ingredients.size(); ++i) {
            int y;
            int x;
            if (ingredients.size() <= 3) {
                int totalWidth = ingredients.size() * 18;
                int startX = 19 + (36 - totalWidth) / 2;
                x = startX + i * 18;
                y = 13;
            } else if (ingredients.size() == 4) {
                row = i / 2;
                col = i % 2;
                x = 19 + col * 18;
                y = 4 + row * 18;
            } else if (ingredients.size() < 7) {
                row = i / 3;
                col = i % 3;
                totalWidth = 54;
                x = 19 + col * 18 + (36 - totalWidth) / 2;
                y = 4 + row * 18;
            } else {
                row = i / 4;
                col = i % 4;
                totalWidth = 72;
                x = 19 + col * 18 + (36 - totalWidth) / 2;
                y = 4 + row * 18;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, x + 1, y + 1).addIngredients((Ingredient)ingredients.get(i));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 74, 14).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.stream(recipe.fluidIngredient().getFluids()).toList())).addRichTooltipCallback((recipeSlotView, tooltip) -> recipeSlotView.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).ifPresent(fluid -> {
            int amount = fluid.getAmount();
            tooltip.add((FormattedText)Component.literal((String)(amount + " mB")).withColor(0x808080));
        }));
        if (!recipe.getResultItem((HolderLookup.Provider)access).isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 121, 14).addItemStack(recipe.getResultItem((HolderLookup.Provider)access));
        }
        recipe.resultFluid().ifPresent(fluidStack -> ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 139, 14).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStack)).addRichTooltipCallback((recipeSlotView, tooltip) -> recipeSlotView.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).ifPresent(fluid -> {
            int amount = fluid.getAmount();
            tooltip.add((FormattedText)Component.literal((String)(amount + " mB")).withColor(0x808080));
        })));
    }
}

