/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.compat.modonomicon;

import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.modonomicon.client.render.page.BookRecipePageRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.compat.modonomicon.BookToolAssemblyRecipePage;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.MaterialComponent;
import net.stln.magitech.item.component.PartMaterialComponent;
import net.stln.magitech.item.tool.material.ToolMaterial;
import net.stln.magitech.recipe.ToolAssemblyRecipe;
import net.stln.magitech.util.ClientHelper;
import net.stln.magitech.util.ToolMaterialUtil;
import oshi.util.tuples.Pair;

public class BookToolAssemblyRecipePageRenderer
extends BookRecipePageRenderer<ToolAssemblyRecipe, BookToolAssemblyRecipePage> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"magitech", (String)"textures/gui/book_tool_assembly.png");
    private final List<ItemStack> inputs = new ArrayList<ItemStack>();
    List<Pair<List<ItemStack>, ItemStack>> displayList = new ArrayList<Pair<List<ItemStack>, ItemStack>>();
    private ItemStack output = ItemStack.EMPTY;

    public BookToolAssemblyRecipePageRenderer(BookToolAssemblyRecipePage page) {
        super((BookRecipePage)page);
    }

    protected int getRecipeHeight() {
        return 75;
    }

    protected void drawRecipe(GuiGraphics guiGraphics, RecipeHolder<ToolAssemblyRecipe> recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        RegistryAccess registries;
        if (!second) {
            if (!((BookToolAssemblyRecipePage)this.page).getTitle1().isEmpty()) {
                this.renderTitle(guiGraphics, ((BookToolAssemblyRecipePage)this.page).getTitle1(), false, 62, 0);
            }
        } else if (!((BookToolAssemblyRecipePage)this.page).getTitle2().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookToolAssemblyRecipePage)this.page).getTitle2(), false, 62, recipeY - (((BookToolAssemblyRecipePage)this.page).getTitle2().getString().isEmpty() ? 10 : 0) - 5);
        }
        RenderSystem.enableBlend();
        guiGraphics.blit(TEXTURE, recipeX - 2, recipeY + 7, 0.0f, 0.0f, 97, 39, 97, 39);
        int wrap = 3;
        ((ToolAssemblyRecipe)recipe.value()).getIngredients().forEach(ing -> {
            if (ing.getItems().length > 0) {
                this.inputs.add(ing.getItems()[0]);
            }
        });
        RegistryAccess registryAccess = registries = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : null;
        if (registries == null) {
            return;
        }
        this.output = ((ToolAssemblyRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registries);
        if (this.displayList.isEmpty()) {
            this.setDisplayList();
        }
        for (int i = 0; i < ((List)this.displayList.getFirst().getA()).size(); ++i) {
            int finalI = i;
            this.parentScreen.renderItemStacks(guiGraphics, recipeX + i % wrap * 19, recipeY + i / wrap * 19 + 9, mouseX, mouseY, this.displayList.stream().map(p -> (ItemStack)((List)p.getA()).get(finalI)).toList());
        }
        this.parentScreen.renderItemStacks(guiGraphics, recipeX + 76, recipeY + 18, mouseX, mouseY, this.displayList.stream().map(Pair::getB).toList());
        this.parentScreen.renderItemStack(guiGraphics, recipeX + 76, recipeY + 38, mouseX, mouseY, BlockInit.ASSEMBLY_WORKBENCH_ITEM.toStack());
    }

    private void setDisplayList() {
        RecipeManager recipeManager;
        RecipeManager recipeManager2 = recipeManager = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.getRecipeManager() : null;
        if (recipeManager == null) {
            return;
        }
        List<ToolMaterial> materials = ClientHelper.getAllCraftableMaterials();
        int size = this.inputs.size();
        int indexSize = (int)Math.pow(materials.size(), size);
        ArrayList inputList = new ArrayList();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int idx = 0; idx < indexSize; idx += 10) {
            List<ToolMaterial> materialList = ToolMaterialUtil.getMaterialCombinationAt(materials, size, idx);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < size; ++i) {
                ItemStack returnStack = this.inputs.get(i).copy();
                returnStack.set(ComponentInit.MATERIAL_COMPONENT, (Object)new MaterialComponent(materialList.get(i)));
                stacks.add(returnStack);
            }
            inputList.add(stacks);
            ItemStack result = this.output.copy();
            ArrayList<ToolMaterial> reversed = new ArrayList<ToolMaterial>(materialList);
            Collections.reverse(reversed);
            result.set(ComponentInit.PART_MATERIAL_COMPONENT, (Object)new PartMaterialComponent(reversed));
            results.add(result);
        }
        for (int i = 0; i < inputList.size(); ++i) {
            this.displayList.add((Pair<List<ItemStack>, ItemStack>)new Pair((Object)((List)inputList.get(i)), (Object)((ItemStack)results.get(i))));
        }
        Collections.shuffle(this.displayList);
    }
}

