/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity;

import java.util.EnumSet;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class RangedSpellAttackGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int attackInterval = 40;
    private int hardAttackInterval = 20;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public RangedSpellAttackGoal(T mob, double moveSpeedAmp, float maxAttackDistance, int attackInterval, int hardAttackInterval) {
        this.mob = mob;
        this.moveSpeedAmp = moveSpeedAmp;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.attackInterval = attackInterval;
        this.hardAttackInterval = hardAttackInterval;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        return target != null && target.isAlive();
    }

    public void stop() {
        this.attackTime = -1;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean flag1;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        double d0 = this.mob.distanceToSqr(target.getX(), target.getY(), target.getZ());
        boolean flag = this.mob.getSensing().hasLineOfSight((Entity)target);
        boolean bl = flag1 = this.seeTime > 0;
        if (flag != flag1) {
            this.seeTime = 0;
        }
        this.seeTime = flag ? ++this.seeTime : --this.seeTime;
        if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
            this.mob.getNavigation().stop();
            ++this.strafingTime;
        } else {
            this.mob.getNavigation().moveTo((Entity)target, this.moveSpeedAmp);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            Entity entity = this.mob.getControlledVehicle();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.lookAt((Entity)target, 30.0f, 30.0f);
            }
            this.mob.lookAt((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        double distanceSq = this.mob.distanceToSqr((Entity)target);
        boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)target);
        if (--this.attackTime <= 0 && canSee && distanceSq <= (double)this.maxAttackDistance) {
            ((RangedAttackMob)this.mob).performRangedAttack(target, 1.0f);
            this.attackTime = this.mob.level().getDifficulty() == Difficulty.HARD ? this.hardAttackInterval : this.attackInterval;
        }
    }
}

