/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.client.animation;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import java.util.Optional;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.stln.magitech.Magitech;
import net.stln.magitech.entity.status.AttributeInit;
import net.stln.magitech.magic.mana.UsedHandData;

@EventBusSubscriber(modid="magitech", value={Dist.CLIENT})
public class PlayerAnimatorInit {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(Magitech.id("animation"), 42, abstractClientPlayer -> {
            UsedHandData.setUsedHand((Player)abstractClientPlayer, false);
            boolean[] mirror = UsedHandData.getUsedHand((Player)abstractClientPlayer);
            ModifierLayer testAnimation = new ModifierLayer();
            testAnimation.addModifierBefore((AbstractModifier)new AbstractFadeModifier(1){

                protected float getAlpha(String s, TransformType transformType, float v) {
                    return 0.0f;
                }
            });
            testAnimation.addModifierBefore((AbstractModifier)new MirrorModifier(){

                public boolean isEnabled() {
                    return UsedHandData.getUsedHand((Player)abstractClientPlayer)[0];
                }
            });
            testAnimation.addModifierBefore((AbstractModifier)new AdjustmentModifier(part -> {
                if (part.equals("head")) {
                    return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, (float)Math.toRadians(abstractClientPlayer.yBodyRot - abstractClientPlayer.yHeadRot) * (float)(mirror[0] ? -1 : 1), 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
                }
                if (part.equals("body")) {
                    return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, (float)Math.toRadians(abstractClientPlayer.yBodyRot - abstractClientPlayer.yHeadRot) * (float)(mirror[0] ? -1 : 1), 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
                }
                return Optional.empty();
            }));
            testAnimation.addModifierBefore((AbstractModifier)new SpeedModifier(){

                protected void step(float delta) {
                    super.step((float)((double)delta * abstractClientPlayer.getAttributeValue(AttributeInit.CASTING_SPEED)));
                }
            });
            return testAnimation;
        });
    }

    private static IAnimation registerPlayerAnimation(AbstractClientPlayer player) {
        return new ModifierLayer();
    }
}

