/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.magicentity.nullixis;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.stln.magitech.element.Element;
import net.stln.magitech.entity.EntityInit;
import net.stln.magitech.entity.SpellProjectileEntity;
import net.stln.magitech.particle.particle_option.VoidGlowParticleEffect;
import net.stln.magitech.sound.SoundInit;
import net.stln.magitech.util.DataMapHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NullixisEntity
extends SpellProjectileEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public NullixisEntity(EntityType<? extends SpellProjectileEntity> entityType, Level world) {
        super(entityType, world);
    }

    public NullixisEntity(Level world, Player player, float damage) {
        super(EntityInit.NULLIXIS_ENTITY.get(), (LivingEntity)player, world, null, damage);
    }

    public NullixisEntity(Level world, Player player, ItemStack weapon, float damage) {
        super(EntityInit.NULLIXIS_ENTITY.get(), (LivingEntity)player, world, weapon, damage);
    }

    public NullixisEntity(EntityType<? extends SpellProjectileEntity> type, double x, double y, double z, Level world, ItemStack stack, @Nullable ItemStack weapon, float damage) {
        super(type, x, y, z, world, weapon, damage);
    }

    public NullixisEntity(EntityType<? extends SpellProjectileEntity> type, LivingEntity owner, Level world, ItemStack stack, @Nullable ItemStack shotFrom, float damage) {
        super(type, owner, world, shotFrom, damage);
    }

    @Override
    public void tick() {
        block10: {
            BlockHitResult hitresult;
            block11: {
                super.tick();
                Vec3 vec32 = this.position();
                Vec3 vec33 = vec32.add(this.getDeltaMovement().scale(3.0));
                hitresult = this.level().clip(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (hitresult.getType() != HitResult.Type.MISS) {
                    vec33 = hitresult.getLocation();
                }
                if (this.isRemoved()) break block10;
                EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult == null || hitresult.getType() == HitResult.Type.MISS) break block11;
                if (EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) break block10;
                ProjectileDeflection projectiledeflection = this.hitTargetOrDeflectSelf((HitResult)hitresult);
                this.hasImpulse = true;
                if (projectiledeflection != ProjectileDeflection.NONE) break block10;
            }
            if (hitresult != null) {
                hitresult.getType();
            }
        }
        Level world = this.level();
        Vec3 deltaMovement = this.getDeltaMovement();
        if (world.isClientSide) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(1.0f, 1.0f, 1.0f);
            float scale = 1.0f;
            int twinkle = 1;
            float rotSpeed = 0.0f;
            int particleAmount = 5;
            for (int i = 0; i < particleAmount; ++i) {
                double x = this.getX() - deltaMovement.x + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double y = this.getY(0.5) - deltaMovement.y + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double z = this.getZ() - deltaMovement.z + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double vx = deltaMovement.x / 4.0;
                double vy = deltaMovement.y / 4.0;
                double vz = deltaMovement.z / 4.0;
                world.addParticle((ParticleOptions)new VoidGlowParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        }
        int axisX = this.tickCount % 3 != 0 ? -1 : 2;
        int axisY = this.tickCount % 3 != 1 ? -1 : 2;
        int axisZ = this.tickCount % 3 != 2 ? -1 : 2;
        this.setPos(deltaMovement.x * (double)axisX + this.position().x, deltaMovement.y * (double)axisY + this.position().y, deltaMovement.z * (double)axisZ + this.position().z);
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        ResourceKey<DamageType> damageType = this.getElement().getDamageType();
        DamageSource elementalDamageSource = this.getElementalDamageSource(owner, damageType);
        float finalDamage = this.damage * DataMapHelper.getElementMultiplier(entity, this.getElement());
        this.applyDamage(entity, elementalDamageSource, finalDamage);
        this.hitParticle();
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
    }

    @Override
    protected Element getElement() {
        return Element.HOLLOW;
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            if (this.level().isClientSide) {
                this.hitParticle();
            } else {
                this.discard();
            }
        }
        super.handleEntityEvent(status);
    }

    protected void hitParticle() {
        Level world = this.level();
        if (world.isClientSide) {
            Vector3f fromColor = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f toColor = new Vector3f(1.0f, 1.0f, 1.0f);
            float scale = 1.0f;
            float rotSpeed = 0.0f;
            int particleAmount = 10;
            for (int i = 0; i < particleAmount; ++i) {
                int twinkle = 1;
                double x = this.getX() - this.getDeltaMovement().x + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double y = this.getY(0.5) - this.getDeltaMovement().y + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double z = this.getZ() - this.getDeltaMovement().z + ((double)this.random.nextFloat() - 0.5) / 10.0;
                double vx = ((double)this.random.nextFloat() - 0.5) / 6.0;
                double vy = ((double)this.random.nextFloat() - 0.5) / 6.0;
                double vz = ((double)this.random.nextFloat() - 0.5) / 6.0;
                Vector3f endPos = this.position().add(new Vec3((double)(this.random.nextFloat() * 4.0f - 2.0f), (double)(this.random.nextFloat() * 4.0f - 2.0f), (double)(this.random.nextFloat() * 4.0f - 2.0f))).toVector3f();
                world.addParticle((ParticleOptions)new VoidGlowParticleEffect(fromColor, toColor, scale, twinkle, rotSpeed), x, y, z, vx, vy, vz);
            }
        }
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundInit.NULLIXIS.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idle", event -> event.setAndContinue(IDLE)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

