/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.entity.mob_effect;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.stln.magitech.entity.mob_effect.CustomMobEffect;
import net.stln.magitech.particle.particle_option.PowerupNoCullParticleEffect;
import net.stln.magitech.particle.particle_option.WaveNoCullParticleEffect;
import org.joml.Vector3f;

class EcholocationMobEffect
extends CustomMobEffect {
    protected EcholocationMobEffect(MobEffectCategory mobEffectCategory, int i) {
        super(mobEffectCategory, i);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.level().isClientSide) {
            for (int i = -5; i < 6; ++i) {
                for (int j = -5; j < 6; ++j) {
                    for (int k = -5; k < 6; ++k) {
                        BlockPos blockPos = livingEntity.blockPosition().above(i).east(j).south(k);
                        BlockState blockState = livingEntity.level().getBlockState(blockPos);
                        if (!blockState.getTags().anyMatch(Predicate.isEqual(Tags.Blocks.ORES))) continue;
                        Vec3 center = blockPos.getCenter();
                        Vec3 corner = Vec3.atLowerCornerOf((Vec3i)blockPos);
                        livingEntity.level().addParticle((ParticleOptions)new WaveNoCullParticleEffect(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), 4.0f, 1, 0.0f), center.x, center.y, center.z, 0.0, 0.0, 0.0);
                        for (int l = 0; l < 3; ++l) {
                            livingEntity.level().addParticle((ParticleOptions)new PowerupNoCullParticleEffect(new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 1.0f, 1.0f), 1.0f, 1, 0.0f), corner.x + (double)livingEntity.getRandom().nextFloat(), corner.y + (double)livingEntity.getRandom().nextFloat(), corner.z + (double)livingEntity.getRandom().nextFloat(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

