/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.fluid;

import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.stln.magitech.Magitech;
import net.stln.magitech.fluid.EmberPotionFluid;
import net.stln.magitech.fluid.FlowPotionFluid;
import net.stln.magitech.fluid.GlacePotionFluid;
import net.stln.magitech.fluid.HealingPotionFluid;
import net.stln.magitech.fluid.HollowPotionFluid;
import net.stln.magitech.fluid.MagicPotionFluid;
import net.stln.magitech.fluid.ManaPotionFluid;
import net.stln.magitech.fluid.ManaSolutionFluid;
import net.stln.magitech.fluid.PhantomPotionFluid;
import net.stln.magitech.fluid.SulfuricAcidFluid;
import net.stln.magitech.fluid.SurgePotionFluid;
import net.stln.magitech.fluid.TremorPotionFluid;

@EventBusSubscriber
public class FluidInit {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"magitech");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"magitech");
    public static final DeferredHolder<FluidType, FluidType> SULFURIC_ACID_TYPE = FluidInit.registerFluidType("sulfuric_acid", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> MANA_SOLUTION_TYPE = FluidInit.registerFluidType("mana_solution", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> MANA_POTION_TYPE = FluidInit.registerFluidType("mana_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> HEALING_POTION_TYPE = FluidInit.registerFluidType("healing_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> EMBER_POTION_TYPE = FluidInit.registerFluidType("ember_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> GLACE_POTION_TYPE = FluidInit.registerFluidType("glace_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> SURGE_POTION_TYPE = FluidInit.registerFluidType("surge_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> PHANTOM_POTION_TYPE = FluidInit.registerFluidType("phantom_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> TREMOR_POTION_TYPE = FluidInit.registerFluidType("tremor_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> MAGIC_POTION_TYPE = FluidInit.registerFluidType("magic_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> FLOW_POTION_TYPE = FluidInit.registerFluidType("flow_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<FluidType, FluidType> HOLLOW_POTION_TYPE = FluidInit.registerFluidType("hollow_potion", new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, Fluid> SULFURIC_ACID = FluidInit.registerFluid("sulfuric_acid", SulfuricAcidFluid::new);
    public static final DeferredHolder<Fluid, Fluid> MANA_SOLUTION = FluidInit.registerFluid("mana_solution", ManaSolutionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> MANA_POTION = FluidInit.registerFluid("mana_potion", ManaPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> HEALING_POTION = FluidInit.registerFluid("healing_potion", HealingPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> EMBER_POTION = FluidInit.registerFluid("ember_potion", EmberPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> GLACE_POTION = FluidInit.registerFluid("glace_potion", GlacePotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> SURGE_POTION = FluidInit.registerFluid("surge_potion", SurgePotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> PHANTOM_POTION = FluidInit.registerFluid("phantom_potion", PhantomPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> TREMOR_POTION = FluidInit.registerFluid("tremor_potion", TremorPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> MAGIC_POTION = FluidInit.registerFluid("magic_potion", MagicPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> FLOW_POTION = FluidInit.registerFluid("flow_potion", FlowPotionFluid::new);
    public static final DeferredHolder<Fluid, Fluid> HOLLOW_POTION = FluidInit.registerFluid("hollow_potion", HollowPotionFluid::new);

    private static <S extends FluidType> DeferredHolder<FluidType, S> registerFluidType(String name, S type) {
        return FLUID_TYPES.register(name, () -> type);
    }

    private static <S extends Fluid> DeferredHolder<Fluid, S> registerFluid(String name, Supplier<S> type) {
        return FLUIDS.register(name, type);
    }

    public static void registerFluids(IEventBus eventBus) {
        Magitech.LOGGER.info("Registering Fluids formagitech");
        FLUID_TYPES.register(eventBus);
        FLUIDS.register(eventBus);
    }

    @SubscribeEvent
    public static void registerIClientFluidExtensions(RegisterClientExtensionsEvent event) {
        Magitech.LOGGER.info("Registering IClientFluidExtensions formagitech");
        FluidInit.registerIClientFluidExtension(event, "block/sulfuric_acid_still", SULFURIC_ACID_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/mana_solution_still", MANA_SOLUTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/mana_potion_still", MANA_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/healing_potion_still", HEALING_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/ember_potion_still", EMBER_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/glace_potion_still", GLACE_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/surge_potion_still", SURGE_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/phantom_potion_still", PHANTOM_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/tremor_potion_still", TREMOR_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/magic_potion_still", MAGIC_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/flow_potion_still", FLOW_POTION_TYPE);
        FluidInit.registerIClientFluidExtension(event, "block/hollow_potion_still", HOLLOW_POTION_TYPE);
    }

    private static void registerIClientFluidExtension(RegisterClientExtensionsEvent event, final String s, DeferredHolder<FluidType, FluidType> sulfuricAcidType) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private final ResourceLocation stillTexture;
            {
                this.stillTexture = Magitech.id(s);
            }

            public ResourceLocation getStillTexture() {
                return this.stillTexture;
            }
        }, new Holder[]{sulfuricAcidType});
    }

    public static void registerFluidRenderTypes() {
        Magitech.LOGGER.info("Registering Fluid Render Types formagitech");
        FluidInit.setRenderLayerTranslucent(SULFURIC_ACID);
        FluidInit.setRenderLayerTranslucent(MANA_SOLUTION);
        FluidInit.setRenderLayerTranslucent(MANA_POTION);
        FluidInit.setRenderLayerTranslucent(HEALING_POTION);
        FluidInit.setRenderLayerTranslucent(EMBER_POTION);
        FluidInit.setRenderLayerTranslucent(GLACE_POTION);
        FluidInit.setRenderLayerTranslucent(SURGE_POTION);
        FluidInit.setRenderLayerTranslucent(PHANTOM_POTION);
        FluidInit.setRenderLayerTranslucent(TREMOR_POTION);
        FluidInit.setRenderLayerTranslucent(MAGIC_POTION);
        FluidInit.setRenderLayerTranslucent(FLOW_POTION);
        FluidInit.setRenderLayerTranslucent(HOLLOW_POTION);
    }

    private static void setRenderLayerTranslucent(DeferredHolder<Fluid, Fluid> fluid) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)fluid.get()), (RenderType)RenderType.translucent());
    }
}

