/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.stln.magitech.Magitech;
import net.stln.magitech.gui.PartCuttingMenu;
import net.stln.magitech.gui.ToolStatsPanel;
import net.stln.magitech.recipe.PartCuttingRecipe;
import net.stln.magitech.util.ClientHelper;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PartCuttingScreen
extends AbstractContainerScreen<PartCuttingMenu> {
    private static final ResourceLocation BG_LOCATION = Magitech.id("textures/gui/part_cutting.png");
    private static final int SCROLLER_WIDTH = 8;
    private static final int SCROLLER_HEIGHT = 8;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 18;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 46;
    private static final int RECIPES_Y = 31;
    ItemStack stack = null;
    private float scrollOffs;
    private OwoUIAdapter<FlowLayout> uiAdapter;
    private int bgWidth = 176;
    private int panelWidth = 160;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public PartCuttingScreen(PartCuttingMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        menu.registerUpdateListener(this::containerChanged);
        this.imageWidth = this.bgWidth + this.panelWidth;
        this.imageHeight = 199;
        this.titleLabelY = 4;
        this.inventoryLabelY = 106;
    }

    private static List<Component> getPanelText() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.translatable((String)"recipe.magitech.part_cutting.panel.title").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))));
        components.add((Component)Component.translatable((String)"recipe.magitech.part_cutting.panel.text"));
        return components;
    }

    public void containerTick() {
        super.containerTick();
        if (!((PartCuttingMenu)this.menu).resultSlot.getItem().equals(this.stack)) {
            this.reloadUI();
            this.stack = ((PartCuttingMenu)this.menu).resultSlot.getItem();
        }
    }

    protected void init() {
        super.init();
        this.uiAdapter = OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
        this.reloadUI();
    }

    private void reloadUI() {
        FlowLayout root = (FlowLayout)this.uiAdapter.rootComponent;
        root.clearChildren();
        ToolStatsPanel.addPartPanel(root, Positioning.absolute((int)(this.leftPos + this.bgWidth), (int)this.topPos), ((PartCuttingMenu)this.menu).resultSlot.getItem(), (Component)Component.translatable((String)"recipe.magitech.tool_stats_panel"), PartCuttingScreen.getPanelText());
        this.uiAdapter.inflateAndMount();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BG_LOCATION, i, j, 0, 0, this.bgWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        int offset = this.isScrollBarActive() ? 0 : 8;
        guiGraphics.blit(BG_LOCATION, i + 121, j + 31 + k, offset, 240, 8, 8);
        int l = this.leftPos + 46;
        int i1 = this.topPos + 30;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, mouseX, mouseY, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.displayRecipes) {
            int i = this.leftPos + 46;
            int j = this.topPos + 30;
            int k = this.startIndex + 12;
            List<RecipeHolder<PartCuttingRecipe>> list = ((PartCuttingMenu)this.menu).getRecipes();
            for (int l = this.startIndex; l < k && l < ((PartCuttingMenu)this.menu).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 18;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 18 || y < k1 || y >= k1 + 18) continue;
                guiGraphics.renderTooltip(this.font, ((PartCuttingRecipe)list.get(l).value()).assemble(new SingleRecipeInput(((PartCuttingMenu)this.menu).inputSlot.getItem()), (HolderLookup.Provider)this.minecraft.level.registryAccess()), x, y);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int lastVisibleElementIndex) {
        for (int i = this.startIndex; i < lastVisibleElementIndex && i < ((PartCuttingMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 18;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            int offx = 0;
            int offy = 0;
            if (i == ((PartCuttingMenu)this.menu).getSelectedRecipeIndex()) {
                offy = 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 18 && mouseY < i1 + 18) {
                offx = 18;
            }
            guiGraphics.blit(BG_LOCATION, k, i1 - 1, offx, offy + 200, 18, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int x, int y, int startIndex) {
        List<RecipeHolder<PartCuttingRecipe>> list = ((PartCuttingMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < startIndex && i < ((PartCuttingMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + 1 + j % 4 * 18;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            PartCuttingRecipe recipe = (PartCuttingRecipe)list.get(i).value();
            int count = recipe.inputCount();
            ItemStack assembled = recipe.assemble(new SingleRecipeInput(((PartCuttingMenu)this.menu).inputSlot.getItem()), (HolderLookup.Provider)this.minecraft.level.registryAccess());
            guiGraphics.drawString(Minecraft.getInstance().font, String.valueOf(count), k, i1, 0x999999, false);
            guiGraphics.renderItem(assembled, k, i1);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Player player = ClientHelper.getPlayer();
        if (player == null) {
            return false;
        }
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 46;
            int j = this.topPos + 30;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = mouseX - (double)(i + i1 % 4 * 18);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 18.0) || !(d1 < 18.0) || !((PartCuttingMenu)this.menu).clickMenuButton(player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((PartCuttingMenu)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = this.leftPos + 119;
        int j = this.topPos + 9;
        if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
            this.scrolling = true;
        }
        if (!this.isScrollBarActive() || !this.scrolling) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        int k = this.getOffscreenRows();
        float f = (float)scrollY / (float)k;
        this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffs * (float)k) + 0.5) * 4;
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((PartCuttingMenu)this.menu).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((PartCuttingMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((PartCuttingMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

