/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.stln.magitech.gui.GuiInit;
import net.stln.magitech.item.ItemInit;
import net.stln.magitech.item.ThreadBoundItem;
import net.stln.magitech.item.ThreadPageItem;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.SpellComponent;
import net.stln.magitech.item.component.ThreadPageComponent;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.magic.spell.SpellLike;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.CuriosHelper;
import org.jetbrains.annotations.NotNull;

public class ThreadboundMenuType
extends AbstractContainerMenu {
    private final ItemStack threadbound;
    private final SimpleContainer container = new SimpleContainer(15);
    private final int containerRows = 3;
    private final int containerColumns = 5;

    public ThreadboundMenuType(int containerId, Inventory playerInv) {
        this(containerId, playerInv, playerInv.player, playerInv.player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ThreadBoundItem ? playerInv.player.getItemInHand(InteractionHand.MAIN_HAND) : playerInv.player.getItemInHand(InteractionHand.OFF_HAND));
    }

    public ThreadboundMenuType(int containerId, Inventory playerInv, Player player, ItemStack threadbound) {
        super(GuiInit.THREADBOUND_MENU.get(), containerId);
        if (!(threadbound.getItem() instanceof ThreadBoundItem)) {
            threadbound = CuriosHelper.getThreadBoundStack((LivingEntity)player).orElse(ItemStack.EMPTY);
        }
        this.threadbound = threadbound;
        for (int i = 0; i < 15; ++i) {
            this.addSlot(new Slot(this, (Container)this.container, i, 44 + 18 * (i % 5), 27 + 18 * (i / 5)){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.getItem() instanceof ThreadPageItem;
                }

                public void set(@NotNull ItemStack stack) {
                    this.setChanged();
                    super.set(stack);
                }
            });
        }
        this.addInventory(playerInv);
        this.addHotbar(playerInv);
        List<Spell> spells = ComponentHelper.getSpells((DataComponentHolder)threadbound).spells();
        for (int i = 0; i < Math.min(spells.size(), this.container.getContainerSize()); ++i) {
            ItemStack stack = new ItemStack((ItemLike)ItemInit.THREAD_PAGE.get());
            stack.set(ComponentInit.THREAD_PAGE_COMPONENT, (Object)new ThreadPageComponent(spells.get(i)));
            this.container.setItem(i, stack);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.containerRows * 5 ? !this.moveItemStackTo(itemstack1, this.containerRows * 5, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.containerRows * 5, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return CuriosHelper.getThreadBoundStack((LivingEntity)player).isPresent();
    }

    private void addInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 112 + i * 18));
            }
        }
    }

    private void addHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 170));
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.updateComponent();
    }

    public void removed(@NotNull Player player) {
        ItemStack carried = this.getCarried();
        if (!carried.isEmpty() && !player.level().isClientSide) {
            player.drop(carried.copy(), false);
            this.setCarried(ItemStack.EMPTY);
        }
        super.removed(player);
    }

    public void updateComponent() {
        ArrayList<SpellLike> spells = new ArrayList<SpellLike>();
        for (int i = 0; i < 15; ++i) {
            ComponentHelper.getThreadPageSpell((DataComponentHolder)this.container.getItem(i)).ifPresent(spells::add);
        }
        this.threadbound.set(ComponentInit.SPELL_COMPONENT, (Object)new SpellComponent(spells));
    }
}

