/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import java.util.List;
import java.util.Random;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.stln.magitech.advancement.CriterionInit;
import net.stln.magitech.block.BlockInit;
import net.stln.magitech.gui.GuiInit;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.UpgradeComponent;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.item.tool.upgrade.Upgrade;
import net.stln.magitech.item.tool.upgrade.UpgradeInstance;
import net.stln.magitech.item.tool.upgrade.UpgradeUtil;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.ToolMaterialUtil;
import org.jetbrains.annotations.NotNull;

public class ToolUpgradeMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerLevelAccess access;
    private final Level level;
    List<Upgrade> upgrades = List.of();
    int upgradeSize = 3;
    long lastSoundTime;
    Runnable slotUpdateListener = () -> {};
    private ItemStack input = ItemStack.EMPTY;
    public final Container container = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            ToolUpgradeMenu.this.slotsChanged((Container)this);
            ToolUpgradeMenu.this.slotUpdateListener.run();
        }
    };

    public ToolUpgradeMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public ToolUpgradeMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(GuiInit.TOOL_UPGRADE_MENU.get(), containerId);
        this.access = access;
        this.level = playerInventory.player.level();
        this.addSlot(new Slot(this.container, 0, 20, 69));
        this.addSlot(new Slot(this.container, 1, 20, 30));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 175));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return ToolUpgradeMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockInit.UPGRADE_WORKBENCH.get()));
    }

    public boolean clickMenuButton(@NotNull Player player, int id) {
        if (this.isValidUpgrade(id)) {
            ItemStack stack = this.container.getItem(0);
            stack.update(ComponentInit.UPGRADE_COMPONENT, (Object)UpgradeComponent.EMPTY, upgradeComponent -> upgradeComponent.addUpgrade(new UpgradeInstance(1, this.upgrades.get(id))));
            stack.set(ComponentInit.UPGRADE_SEED_COMPONENT, (Object)player.getRandom().nextInt(Integer.MAX_VALUE));
            ComponentHelper.updateUpgradePoint((MutableDataComponentHolder)stack, value -> value - 1);
            this.container.setItem(0, stack);
            ItemStack material = this.container.getItem(1).copy();
            material.shrink(1);
            this.container.setItem(1, material);
            player.level().playSound(player, (Entity)player, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.level().isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriterionInit.TOOL_UPGRADE.get().trigger(serverPlayer, stack, ComponentHelper.getTier((DataComponentHolder)stack) - ComponentHelper.getUpgradePoint((DataComponentHolder)stack));
                ((PartToolItem)stack.getItem()).reloadComponent(player, this.level, stack);
            }
        }
        return true;
    }

    private boolean isValidUpgrade(int upgradeIndex) {
        return upgradeIndex >= 0 && upgradeIndex < this.upgradeSize && this.canUpgrade();
    }

    public boolean canUpgrade() {
        ItemStack itemStack = this.container.getItem(0);
        return this.hasUpgradePoint(itemStack) && this.isCorrectMaterialForUpgrade(itemStack);
    }

    public boolean isCorrectMaterialForUpgrade(ItemStack itemStack) {
        return ToolMaterialUtil.isCorrectMaterialForUpgrade(ComponentHelper.getTier((DataComponentHolder)itemStack), ComponentHelper.getUpgradePoint((DataComponentHolder)itemStack), this.container.getItem(1).getItem());
    }

    public boolean hasUpgradePoint(ItemStack itemStack) {
        return !itemStack.isEmpty() && itemStack.getItem() instanceof PartToolItem && ComponentHelper.getUpgradePoint((DataComponentHolder)itemStack) > 0;
    }

    public void slotsChanged(@NotNull Container inventory) {
        ItemStack itemstack = this.container.getItem(0);
        this.input = itemstack.copy();
        this.setupUpgrade(inventory, itemstack);
    }

    private void setupUpgrade(Container container, ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof PartToolItem)) {
            this.upgrades = List.of();
            return;
        }
        if (!stack.has(ComponentInit.UPGRADE_SEED_COMPONENT)) {
            stack.set(ComponentInit.UPGRADE_SEED_COMPONENT, (Object)new Random().nextInt(Integer.MAX_VALUE));
        }
        this.upgrades = UpgradeUtil.getUpgrades(this.upgradeSize, (Integer)stack.get(ComponentInit.UPGRADE_SEED_COMPONENT), stack);
    }

    public MenuType<?> getType() {
        return GuiInit.TOOL_UPGRADE_MENU.get();
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, @NotNull Slot slot) {
        return super.canTakeItemForPickAll(stack, slot);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack;
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 1) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (itemstack1.getItem() instanceof PartToolItem ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (this.hasUpgradePoint(itemStack = this.container.getItem(0)) && ToolMaterialUtil.isCorrectMaterialForUpgrade(ComponentHelper.getTier((DataComponentHolder)itemStack), ComponentHelper.getUpgradePoint((DataComponentHolder)itemStack), itemstack1.getItem()) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((p_40313_, p_40314_) -> this.clearContainer(player, this.container));
    }
}

