/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui;

import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.stln.magitech.Magitech;
import net.stln.magitech.gui.ToolStatsPanel;
import net.stln.magitech.gui.ToolUpgradeMenu;
import net.stln.magitech.item.tool.toolitem.PartToolItem;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;
import net.stln.magitech.item.tool.upgrade.Upgrade;
import net.stln.magitech.item.tool.upgrade.UpgradeInstance;
import net.stln.magitech.item.tool.upgrade.UpgradeRegister;
import net.stln.magitech.util.ClientHelper;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.RenderHelper;
import net.stln.magitech.util.ToolMaterialUtil;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ToolUpgradeScreen
extends AbstractContainerScreen<ToolUpgradeMenu> {
    private static final ResourceLocation BG_LOCATION = Magitech.id("textures/gui/tool_upgrade.png");
    private static final int SWITCH_INTERVAL = 20;
    List<Item> tagItems = new ArrayList<Item>();
    ItemStack stack = null;
    private int tickCounter = 0;
    private int currentIndex = 0;
    private OwoUIAdapter<FlowLayout> uiAdapter;
    private int bgWidth = 176;
    private int panelWidth = 160;

    public ToolUpgradeScreen(ToolUpgradeMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = this.bgWidth + this.panelWidth;
        this.imageHeight = 199;
        this.titleLabelY = 4;
        this.inventoryLabelY = 106;
    }

    private static List<Component> getPanelText() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.translatable((String)"recipe.magitech.tool_upgrade.panel.title").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))));
        components.add((Component)Component.translatable((String)"recipe.magitech.tool_upgrade.panel.text"));
        return components;
    }

    protected void init() {
        super.init();
        this.uiAdapter = OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
        this.reloadUI();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BG_LOCATION, i, j, 0, 0, this.bgWidth, this.imageHeight);
        int l = this.leftPos + 44;
        int i1 = this.topPos + 31;
        int j1 = 3;
        if (((ToolUpgradeMenu)this.menu).canUpgrade()) {
            this.renderButtons(guiGraphics, mouseX, mouseY, l, i1, j1);
        } else {
            ItemStack itemStack = ((ToolUpgradeMenu)this.menu).container.getItem(0);
            if (itemStack.getItem() instanceof PartToolItem) {
                if (((ToolUpgradeMenu)this.menu).hasUpgradePoint(itemStack) && !ToolMaterialUtil.isCorrectMaterialForUpgrade(ComponentHelper.getTier((DataComponentHolder)itemStack), ComponentHelper.getUpgradePoint((DataComponentHolder)itemStack), ((ToolUpgradeMenu)this.menu).container.getItem(1).getItem())) {
                    MutableComponent text = Component.translatable((String)"recipe.magitech.tool_upgrade.incorrect_material");
                    guiGraphics.drawString(this.font, (Component)text.withColor(15782016), l - this.font.width((FormattedText)text) / 2 + 58, i1 + 15, 0xFFFFFF, false);
                    this.tagItems = BuiltInRegistries.ITEM.getTag(ToolMaterialUtil.getUpgradeMaterialTag(ComponentHelper.getTier((DataComponentHolder)itemStack), ComponentHelper.getUpgradePoint((DataComponentHolder)itemStack))).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).toList();
                    this.currentIndex = Math.min(this.currentIndex, this.tagItems.size() - 1);
                    guiGraphics.renderItem(new ItemStack((ItemLike)this.tagItems.get(this.currentIndex)), l - 8 + 58, i1 + 31);
                } else {
                    MutableComponent text = Component.translatable((String)"recipe.magitech.tool_upgrade.no_upgrade_point");
                    guiGraphics.drawString(this.font, (Component)text.withColor(0xFF8080), l - this.font.width((FormattedText)text) / 2 + 58, i1 + 23, 0xFFFFFF, false);
                }
            } else {
                MutableComponent text = Component.translatable((String)"recipe.magitech.tool_upgrade.no_tool");
                guiGraphics.drawString(this.font, (Component)text.withColor(0x202020), l - this.font.width((FormattedText)text) / 2 + 58, i1 + 23, 0xFFFFFF, false);
            }
        }
    }

    protected void containerTick() {
        super.containerTick();
        if (this.stack != ((ToolUpgradeMenu)this.menu).container.getItem(0)) {
            this.reloadUI();
            this.stack = ((ToolUpgradeMenu)this.menu).container.getItem(0);
        }
        if (!this.tagItems.isEmpty()) {
            ++this.tickCounter;
            if (this.tickCounter >= 20) {
                this.tickCounter = 0;
                this.currentIndex = (this.currentIndex + 1) % this.tagItems.size();
            }
        }
    }

    private void reloadUI() {
        FlowLayout root = (FlowLayout)this.uiAdapter.rootComponent;
        root.clearChildren();
        ToolStatsPanel.addPanel(root, Positioning.absolute((int)(this.leftPos + this.bgWidth), (int)this.topPos), ((ToolUpgradeMenu)this.menu).container.getItem(0), (Component)Component.translatable((String)"recipe.magitech.tool_stats_panel"), ToolUpgradeScreen.getPanelText());
        this.uiAdapter.inflateAndMount();
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        ItemStack itemStack = ((ToolUpgradeMenu)this.menu).container.getItem(0);
        int i = this.leftPos + 44;
        int j = this.topPos + 31;
        int k = 3;
        if (((ToolUpgradeMenu)this.menu).canUpgrade()) {
            for (int l = 0; l < k; ++l) {
                if (x < i || x >= i + 117 || y < j + 18 * l || y >= j + 18 + 18 * l) continue;
                List<Component> upgradeTooltips = RenderHelper.getUpgradeTooltips(List.of(new UpgradeInstance(1, ((ToolUpgradeMenu)this.menu).upgrades.get(l))), ((PartToolItem)itemStack.getItem()).getToolType(), itemStack.getItem() instanceof SpellCasterItem);
                upgradeTooltips.addFirst((Component)Component.translatable((String)"recipe.magitech.tool_upgrade.click_to_apply").withStyle(style -> style.withColor(15782016)));
                guiGraphics.renderTooltip(this.font, upgradeTooltips, Optional.empty(), x, y);
            }
        }
        if (!((ToolUpgradeMenu)this.menu).canUpgrade() && ((ToolUpgradeMenu)this.menu).hasUpgradePoint(itemStack) && itemStack.getItem() instanceof PartToolItem && !ToolMaterialUtil.isCorrectMaterialForUpgrade(ComponentHelper.getTier((DataComponentHolder)itemStack), ComponentHelper.getUpgradePoint((DataComponentHolder)itemStack), ((ToolUpgradeMenu)this.menu).container.getItem(1).getItem()) && x >= i + 50 && x < i + 66 && y >= j + 31 && y < j + 47) {
            guiGraphics.renderTooltip(this.font, new ItemStack((ItemLike)this.tagItems.get(this.currentIndex)), x, y);
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int lastVisibleElementIndex) {
        ItemStack stack = ((ToolUpgradeMenu)this.menu).container.getItem(0);
        if (stack.getItem() instanceof PartToolItem) {
            List<UpgradeInstance> upgrades = ComponentHelper.getUpgrades((DataComponentHolder)stack);
            List<Upgrade> currentUpgrades = ((ToolUpgradeMenu)this.menu).upgrades;
            for (int i = 0; i < lastVisibleElementIndex; ++i) {
                int i1 = y + i * 18;
                int level = 0;
                for (UpgradeInstance upgrade : upgrades) {
                    if (!currentUpgrades.get(i).equals(upgrade.upgrade())) continue;
                    level = upgrade.level();
                    break;
                }
                int yOffset = 200;
                if (mouseX >= x && mouseX < x + 117 && mouseY >= i1 && mouseY < i1 + 18) {
                    yOffset += 24;
                }
                ResourceLocation id = UpgradeRegister.getId(currentUpgrades.get(i));
                guiGraphics.blit(BG_LOCATION, x, i1, 0, yOffset, 117, 18);
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)("upgrade." + id.getNamespace() + "." + id.getPath())).withColor(0xE0E0E0).append((Component)Component.literal((String)(" Lv." + level)).withColor(15782016)), x + 5, i1 + 5, 0xFFFFFF, false);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int i = this.leftPos + 44;
        int j = this.topPos + 31;
        int k = 3;
        for (int l = 0; l < k; ++l) {
            double d0 = mouseX - (double)i;
            double d1 = mouseY - (double)(j + l * 18);
            Player player = ClientHelper.getPlayer();
            if (player == null) {
                return false;
            }
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 117.0) || !(d1 < 18.0) || !((ToolUpgradeMenu)this.menu).clickMenuButton(player, l)) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            this.minecraft.gameMode.handleInventoryButtonClick(((ToolUpgradeMenu)this.menu).containerId, l);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

