/*
 * Decompiled with CFR 0.152.
 */
package net.stln.magitech.gui.overlay;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import net.stln.magitech.Magitech;
import net.stln.magitech.element.Element;
import net.stln.magitech.event.KeyMappingEvent;
import net.stln.magitech.item.component.ComponentInit;
import net.stln.magitech.item.component.SpellComponent;
import net.stln.magitech.item.tool.toolitem.SpellCasterItem;
import net.stln.magitech.magic.cooldown.Cooldown;
import net.stln.magitech.magic.cooldown.CooldownData;
import net.stln.magitech.magic.spell.Spell;
import net.stln.magitech.network.ThreadboundSelectPayload;
import net.stln.magitech.util.ClientHelper;
import net.stln.magitech.util.ColorHelper;
import net.stln.magitech.util.ComponentHelper;
import net.stln.magitech.util.CuriosHelper;
import net.stln.magitech.util.MathUtil;
import net.stln.magitech.util.RenderHelper;
import org.jetbrains.annotations.NotNull;

public class RadialSpellMenuOverlay
extends Screen {
    private static final ResourceLocation TEXTURE = Magitech.id("textures/gui/mana_gauge.png");
    float selectAnimTick = 0.0f;
    float selectTick = 0.0f;
    private int select = -1;
    private int ticks = 0;

    public RadialSpellMenuOverlay() {
        super((Component)Component.empty());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!Minecraft.getInstance().options.hideGui) {
            int x = guiGraphics.guiWidth() / 2;
            int y = guiGraphics.guiHeight() / 2;
            double dx = mouseX - x;
            double dy = mouseY - y;
            double naturalMouseAngle = MathUtil.getGeneralAngle(Math.atan2(dy, dx) + 1.5707963267948966);
            Player player = ClientHelper.getPlayer();
            if (player == null) {
                return;
            }
            SpellComponent spellComponent = CuriosHelper.getThreadBoundStack((LivingEntity)player).map(ComponentHelper::getSpells).orElse(SpellComponent.EMPTY);
            int index = 0;
            Spell selectSpell = null;
            for (Spell spell : spellComponent.spells()) {
                int animLength = 3;
                float animTick = Math.min((float)this.ticks + partialTicks, (float)animLength);
                double scaledAnimTick = (double)animTick / (double)animLength;
                float radius = (int)(96.0 - Math.pow(1.0 - scaledAnimTick, 3.0) * 48.0);
                double mouseAngle = naturalMouseAngle;
                double angle = Math.PI * 2 * (double)index / (double)spellComponent.spells().size();
                float sin = (float)((double)radius * Math.sin(angle));
                float cos = (float)(-((double)radius * Math.cos(angle)));
                float size = (float)Math.pow(scaledAnimTick, 2.0) / 2.0f + 0.5f;
                double min = MathUtil.getGeneralAngle(Math.PI * 2 * ((double)index - 0.5) / (double)spellComponent.spells().size());
                double max = MathUtil.getGeneralAngle(Math.PI * 2 * ((double)index + 0.5) / (double)spellComponent.spells().size());
                if (index == 0) {
                    min -= Math.PI * 2;
                    if (mouseAngle > max) {
                        mouseAngle -= Math.PI * 2;
                    }
                }
                double distance = Math.sqrt(dx * dx + dy * dy);
                if (mouseAngle >= min && mouseAngle <= max && distance > 10.0) {
                    if (this.select != index) {
                        this.select = index;
                        this.selectAnimTick = -partialTicks - (float)this.ticks;
                    }
                    this.selectTick = this.selectAnimTick + (float)this.ticks + partialTicks + 0.01f;
                    size *= (float)(Math.clamp((double)(this.selectTick / 5.0f), 0.0, 0.5) + 1.0);
                    if (distance > 20.0) {
                        selectSpell = spell;
                    }
                } else if (distance <= 10.0) {
                    this.select = -1;
                }
                guiGraphics.blit(spell.getIconId(), (int)((float)x + sin - size * 16.0f), (int)((float)y + cos - size * 16.0f), (int)(size * 32.0f), (int)(size * 32.0f), 0.0f, 0.0f, 32, 32, 32, 32);
                Cooldown cooldown = CooldownData.getCurrentCooldown(player, spell);
                if (cooldown != null) {
                    int shadeHeight = (int)(32.0 * (1.0 - cooldown.getProgress() / cooldown.getCooltime()));
                    guiGraphics.setColor(0.3f, 0.3f, 0.3f, 1.0f);
                    int mulHeight = (int)(size * (float)shadeHeight);
                    guiGraphics.blit(spell.getIconId(), (int)((float)x + sin - size * 16.0f), (int)((float)y + cos + size * 16.0f - (float)mulHeight), (int)(size * 32.0f), mulHeight, 0.0f, (float)(32 - shadeHeight), 32, shadeHeight, 32, 32);
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    guiGraphics.blit(TEXTURE, (int)((float)x + sin - size * 16.0f), (int)((float)y + cos - size * 16.0f), (int)(size * 32.0f), (int)(size * 32.0f), 48.0f, 96.0f, 32, 32, 256, 256);
                    Element element = spell.getElement();
                    int offset = (switch (element) {
                        default -> throw new MatchException(null, null);
                        case Element.NONE -> 0;
                        case Element.EMBER -> 1;
                        case Element.GLACE -> 2;
                        case Element.SURGE -> 3;
                        case Element.PHANTOM -> 4;
                        case Element.TREMOR -> 5;
                        case Element.MAGIC -> 6;
                        case Element.FLOW -> 7;
                        case Element.HOLLOW -> 8;
                    }) * 16;
                    guiGraphics.blit(TEXTURE, (int)((float)x + sin - size * 8.0f), (int)((float)y + cos - size * 8.0f), (int)(size * 16.0f), (int)(size * 16.0f), (float)(72 + offset), 24.0f, 16, 16, 256, 256);
                    Font font = Minecraft.getInstance().font;
                    String text = MathUtil.round((cooldown.getCooltime() - cooldown.getProgress()) / 20.0, 1) + "s";
                    int renderx = (int)((float)x + sin - (float)font.width(text) / 2.0f);
                    int rendery = (int)((float)y + cos + 8.0f * size);
                    if (animTick == (float)animLength) {
                        RenderHelper.renderFramedText(guiGraphics, font, text, renderx, rendery, element);
                    }
                }
                ++index;
            }
            if (selectSpell != null) {
                float squareEase = Math.min(this.selectTick * this.selectTick / 4.0f, 4.0f) * 2.0f;
                String text = selectSpell.getDescription().getString();
                List<Component> componentList = selectSpell.getTooltip(player.level(), player, player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof SpellCasterItem ? player.getItemInHand(InteractionHand.MAIN_HAND) : player.getItemInHand(InteractionHand.OFF_HAND));
                int renderx = x - this.font.width(text) / 2;
                int rendery = (int)((float)(y - 4 + 8) - squareEase - (float)(componentList.size() * 5));
                RenderHelper.renderFramedText(guiGraphics, this.font, text, renderx, rendery, selectSpell.getElement());
                int i = 1;
                for (Component component : componentList) {
                    int tooltipx = x - this.font.width(component.getString()) / 2;
                    int color = component.getStyle().getColor() != null ? component.getStyle().getColor().getValue() : 0xFFFFFF;
                    RenderHelper.renderFramedText(guiGraphics, this.font, component.getString(), tooltipx, rendery + ++i * 10, color, color == selectSpell.getElement().getSpellColor() ? selectSpell.getElement().getSpellDark() : ColorHelper.Argb.mul(color, 0x404060));
                }
            }
        }
    }

    public void tick() {
        super.tick();
        ++this.ticks;
    }

    public void onClose() {
        super.onClose();
        Player player = ClientHelper.getPlayer();
        if (player == null) {
            return;
        }
        CuriosHelper.getThreadBoundStack((LivingEntity)player).ifPresent(stack -> {
            if (stack.has(ComponentInit.SPELL_COMPONENT) && this.select >= 0) {
                IAnimation patt0$temp;
                PacketDistributor.sendToServer((CustomPacketPayload)new ThreadboundSelectPayload(this.select, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                player.releaseUsingItem();
                ComponentHelper.updateSpells((MutableDataComponentHolder)stack, spellComponent -> spellComponent.setSelected(this.select));
                ModifierLayer playerAnimationData = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(Magitech.id("animation"));
                if (playerAnimationData != null && (patt0$temp = playerAnimationData.getAnimation()) instanceof KeyframeAnimationPlayer) {
                    KeyframeAnimationPlayer keyframeAnimationPlayer = (KeyframeAnimationPlayer)patt0$temp;
                    keyframeAnimationPlayer.stop();
                }
            }
        });
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ((KeyMapping)KeyMappingEvent.RADIAL_SPELL_MENU.get()).getKey().getValue()) {
            this.onClose();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

